package com.generation.batch;

import java.util.Hashtable;
import java.util.ResourceBundle;

import javax.naming.Context;
import javax.naming.spi.NamingManager;

import org.apache.log4j.Logger;
import org.postgresql.jdbc2.optional.PoolingDataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * ob`NX
 * @author n@^K
 *
 */
public abstract class BatchBase {

	/** log */
	private static Logger log = Logger.getLogger(BatchBase.class);

	/** ReLXg */
	private Context ctx;
	/** AvP[VReLXg */
	protected ApplicationContext context;
	/** ob` */
	protected String[] args;

	/**
	 * ob`sB
	 * @param args NXz
	 */
	public void batchExecute(String[] args) throws Exception {

		log.info("---------- ob`sJn ----------");

		log.info("ReLXg܂");
		ResourceBundle rb = ResourceBundle.getBundle(BatchConstants.BATCH_PROPERTIES);

		PoolingDataSource ds = new PoolingDataSource();
		ds.setDatabaseName(rb.getString(BatchConstants.DB_NAME));
		ds.setServerName(rb.getString(BatchConstants.DB_HOST));
		ds.setPortNumber(Integer.parseInt(rb.getString(BatchConstants.DB_PORT)));
		ds.setUser(rb.getString(BatchConstants.DB_USER));
		ds.setPassword(rb.getString(BatchConstants.DB_PASS));
		ds.setMaxConnections(Integer.parseInt(rb.getString(BatchConstants.DB_MAX_CONNECT)));

		Hashtable<String, String> env = new Hashtable<String, String>();
		env.put(Context.INITIAL_CONTEXT_FACTORY, "com.generation.batch.BatchContextFactory");
		System.setProperty(Context.INITIAL_CONTEXT_FACTORY, "com.generation.batch.BatchContextFactory");
		ctx = NamingManager.getInitialContext(env);
		ctx.bind(rb.getString(BatchConstants.JNDI_NAME), ds);

		if (args.length != 0) {
			String[] contextParam = {args[0]};
			context = new ClassPathXmlApplicationContext(contextParam);
		} else {
			log.info("ReLXgpXw肳ĂȂ̂[batchApplicationContext.xml]ǂݍ݂܂");
			context = new ClassPathXmlApplicationContext("batchApplicationContext.xml");
		}
		log.info("ReLXg܂");

		// ob`
		this.args = args;

		execute();

		log.info("---------- ob`s ----------");
	}

	/**
	 * ob`又B
	 */
	abstract protected void execute() throws Exception;

}
