/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionUtil {
    private static boolean loaded = false;
    private static final String FILENAME_VERSION = "/dwr-version.properties";
    private static final String KEY_MAJOR = "major";
    private static int major;
    private static final String KEY_MINOR = "minor";
    private static int minor;
    private static final String KEY_REVISION = "revision";
    private static int revision;
    private static final String KEY_BUILD = "build";
    private static int build;
    private static final String KEY_TITLE = "title";
    private static String title;
    private static String label;
    private static final String KEY_SCC_INFO = "scc-info";
    private static String sccInfo;

    public static String getSourceControlInfo() {
        VersionUtil.loadProperties();
        return sccInfo;
    }

    @Deprecated
    public static String getVersion() {
        return VersionUtil.getLabel();
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getRevision() {
        return revision;
    }

    public static int getBuild() {
        return build;
    }

    public static String getTitle() {
        VersionUtil.loadProperties();
        return title;
    }

    public static String getLabel() {
        VersionUtil.loadProperties();
        return label;
    }

    private static synchronized void loadProperties() {
        if (loaded) {
            return;
        }
        try {
            InputStream in = VersionUtil.class.getResourceAsStream(FILENAME_VERSION);
            Properties props = new Properties();
            props.load(in);
            sccInfo = props.getProperty(KEY_SCC_INFO);
            major = Integer.parseInt(props.getProperty(KEY_MAJOR));
            minor = Integer.parseInt(props.getProperty(KEY_MINOR));
            revision = Integer.parseInt(props.getProperty(KEY_REVISION));
            build = Integer.parseInt(props.getProperty(KEY_BUILD));
            title = props.getProperty(KEY_TITLE);
            label = title.length() == 0 ? major + "." + minor + "." + revision : major + "." + minor + "." + revision + "." + build + "." + title;
            loaded = true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

