/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Continuation {
    private final Object proxy;
    private static final Log log = LogFactory.getLog(Continuation.class);
    protected static final Class<?> continuationClass;
    protected static final Method suspendMethod;
    protected static final Method resumeMethod;
    protected static final Method getObject;
    protected static final Method setObject;
    protected static boolean isJetty;
    protected static boolean isGrizzly;

    public Continuation(HttpServletRequest request) {
        Object temp = request.getAttribute("org.mortbay.jetty.ajax.Continuation");
        if (temp == null && Continuation.isGrizzly()) {
            try {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                temp = gMethod.invoke(null, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.proxy = temp;
    }

    public boolean isAvailable() {
        return this.proxy != null;
    }

    public void suspend(long sleepTime) throws Exception {
        try {
            suspendMethod.invoke(this.proxy, sleepTime);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public void resume() throws Exception {
        try {
            resumeMethod.invoke(this.proxy, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public Object getObject() throws Exception {
        try {
            return getObject.invoke(this.proxy, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            return Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public void setObject(Object object) throws Exception {
        try {
            setObject.invoke(this.proxy, object);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public static void rethrowIfContinuation(Throwable th) {
        Throwable ex = th;
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        if ("org.mortbay.jetty.RetryRequest".equals(ex.getClass().getName())) {
            throw (RuntimeException)ex;
        }
    }

    private static Object rethrowWithoutWrapper(InvocationTargetException ex) throws Exception {
        Throwable target = ex.getTargetException();
        if (target instanceof Exception) {
            throw (Exception)target;
        }
        if (target instanceof Error) {
            throw (Error)target;
        }
        throw ex;
    }

    private static Method getMethod(String name, Class<?> ... args) {
        if (continuationClass == null) {
            return null;
        }
        try {
            return continuationClass.getMethod(name, args);
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean isJetty() {
        return isJetty;
    }

    public static boolean isGrizzly() {
        return isGrizzly;
    }

    static {
        isJetty = false;
        isGrizzly = false;
        Class<?> tempContinuationClass = null;
        try {
            try {
                tempContinuationClass = LocalUtil.classForName("org.mortbay.util.ajax.Continuation");
                isJetty = true;
            }
            catch (Exception ex) {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                tempContinuationClass = gMethod.invoke((Object)gMethod, new Object[0]).getClass();
                isGrizzly = true;
            }
        }
        catch (Exception ex) {
            isJetty = false;
            log.debug((Object)"No Jetty or Grizzly Continuation class, using standard Servlet API");
        }
        continuationClass = tempContinuationClass;
        suspendMethod = Continuation.getMethod("suspend", Long.TYPE);
        resumeMethod = Continuation.getMethod("resume", new Class[0]);
        getObject = Continuation.getMethod("getObject", new Class[0]);
        setObject = Continuation.getMethod("setObject", Object.class);
    }
}

