/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.DwrServlet;
import org.directwebremoting.spring.SpringContainer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrSpringServlet
extends DwrServlet {
    private ApplicationContext applicationContext = null;
    private boolean includeDefaultConfig = true;
    private List<Configurator> configurators = new ArrayList<Configurator>();
    protected WebContextFactory.WebContextBuilder webContextBuilder = null;

    @Override
    protected SpringContainer createContainer(ServletConfig servletConfig) {
        ApplicationContext appContext = this.getApplicationContext(servletConfig.getServletContext());
        SpringContainer springContainer = new SpringContainer();
        springContainer.setBeanFactory((BeanFactory)appContext);
        StartupUtil.setupDefaultContainer(springContainer, servletConfig);
        return springContainer;
    }

    @Override
    protected void configureContainer(Container container, ServletConfig servletConfig) throws ServletException, IOException {
        try {
            ApplicationContext appContext = this.getApplicationContext(servletConfig.getServletContext());
            this.configurators.add((Configurator)appContext.getBean("__dwrConfiguration"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ServletException("No DWR configuration was found in your application context, make sure to define one", (Throwable)ex);
        }
        try {
            if (this.includeDefaultConfig) {
                StartupUtil.configureFromSystemDwrXml(container);
            }
            StartupUtil.configureFromInitParams(container, servletConfig);
            StartupUtil.configure(container, this.configurators);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext(ServletContext servletContext) {
        return this.applicationContext == null ? WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext) : this.applicationContext;
    }
}

