/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.create.NewCreator;
import org.directwebremoting.filter.ExtraLatencyAjaxFilter;
import org.directwebremoting.spring.BeanCreator;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.spring.DwrController;
import org.directwebremoting.spring.DwrHandlerMapping;
import org.directwebremoting.spring.SpringConfigurator;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DwrNamespaceHandler
extends NamespaceHandlerSupport {
    protected static final String DEFAULT_SPRING_CONFIGURATOR_ID = "__dwrConfiguration";
    private static final Log log = LogFactory.getLog(DwrNamespaceHandler.class);
    private static final String ELEMENT_CONVERTER = "dwr:converter";
    private static final String ELEMENT_CREATOR = "dwr:creator";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";

    public void init() {
        this.registerBeanDefinitionParser("configuration", new ConfigurationBeanDefinitionParser());
        this.registerBeanDefinitionParser("controller", new ControllerBeanDefinitionParser());
        this.registerBeanDefinitionParser("url-mapping", new UrlMappingBeanDefinitionParser());
        this.registerBeanDefinitionParser("proxy-ref", new ProxyBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("init", new InitDefinitionDecorator());
        this.registerBeanDefinitionDecorator("create", new CreatorBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("convert", new ConverterBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("signatures", new SignaturesBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("remote", new RemoteBeanDefinitionDecorator());
    }

    protected static BeanDefinition registerSpringConfiguratorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SpringConfigurator.class);
            builder.addPropertyValue("creators", (Object)new ManagedMap());
            builder.addPropertyValue("converters", (Object)new ManagedMap());
            registry.registerBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID, (BeanDefinition)builder.getBeanDefinition());
        }
        return registry.getBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID);
    }

    protected void registerCreator(BeanDefinitionRegistry registry, String javascript, BeanDefinitionBuilder creatorConfig, Map<String, String> params, NodeList children) {
        DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(registry);
        ArrayList<String> includes = new ArrayList<String>();
        creatorConfig.addPropertyValue("includes", includes);
        ArrayList<String> excludes = new ArrayList<String>();
        creatorConfig.addPropertyValue("excludes", excludes);
        Properties auth = new Properties();
        creatorConfig.addPropertyValue("auth", (Object)auth);
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if ("dwr:latencyfilter".equals(node.getNodeName())) {
                BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition(ExtraLatencyAjaxFilter.class);
                beanFilter.addPropertyValue("delay", (Object)child.getAttribute("delay"));
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__latencyFilter_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__latencyFilter_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            if ("dwr:include".equals(node.getNodeName())) {
                includes.add(child.getAttribute("method"));
                continue;
            }
            if ("dwr:exclude".equals(node.getNodeName())) {
                excludes.add(child.getAttribute("method"));
                continue;
            }
            if ("dwr:auth".equals(node.getNodeName())) {
                auth.setProperty(child.getAttribute("method"), child.getAttribute("role"));
                continue;
            }
            if ("dwr:convert".equals(node.getNodeName())) {
                element = (Element)node;
                String type = element.getAttribute("type");
                String className = element.getAttribute(ATTRIBUTE_CLASS);
                ConverterConfig converterConfig = new ConverterConfig();
                converterConfig.setType(type);
                this.parseConverterSettings(converterConfig, element);
                DwrNamespaceHandler.lookupConverters(registry).put(className, converterConfig);
                continue;
            }
            if ("dwr:filter".equals(node.getNodeName())) {
                BeanDefinitionBuilder beanFilter;
                element = (Element)node;
                String filterClass = element.getAttribute(ATTRIBUTE_CLASS);
                List filterParamElements = DomUtils.getChildElementsByTagName((Element)element, (String)"param");
                try {
                    beanFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)ClassUtils.forName((String)filterClass));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("DWR filter class '" + filterClass + "' was not found. " + "Check the class name specified in <dwr:filter class=\"" + filterClass + "\" /> exists");
                }
                for (Element filterParamElement : filterParamElements) {
                    beanFilter.addPropertyValue(filterParamElement.getAttribute("name"), (Object)filterParamElement.getAttribute("value"));
                }
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__filter_" + filterClass + "_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__filter_" + filterClass + "_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            if ("dwr:param".equals(node.getNodeName())) {
                element = (Element)node;
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                params.put(name, value);
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was fouund: " + node.getNodeName());
        }
        creatorConfig.addPropertyValue("params", params);
        String creatorConfigName = "__" + javascript;
        BeanDefinitionHolder holder3 = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder3, (BeanDefinitionRegistry)registry);
        DwrNamespaceHandler.lookupCreators(registry).put(javascript, new RuntimeBeanReference(creatorConfigName));
    }

    protected static String resolveBeanClassname(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanClassName = definition.getBeanClassName();
        while (!StringUtils.hasText((String)beanClassName)) {
            try {
                Method m = definition.getClass().getMethod("getParentName", new Class[0]);
                String parentName = (String)m.invoke((Object)definition, new Object[0]);
                BeanDefinition parentDefinition = DwrNamespaceHandler.findParentDefinition(parentName, registry);
                beanClassName = parentDefinition.getBeanClassName();
                definition = parentDefinition;
            }
            catch (Exception e) {
                throw new FatalBeanException("No parent bean could be found for " + definition, (Throwable)e);
            }
        }
        return beanClassName;
    }

    protected static BeanDefinition findParentDefinition(String parentName, BeanDefinitionRegistry registry) {
        if (registry != null) {
            if (registry.containsBeanDefinition(parentName)) {
                return registry.getBeanDefinition(parentName);
            }
            if (registry instanceof HierarchicalBeanFactory) {
                BeanFactory parentBeanFactory = ((HierarchicalBeanFactory)registry).getParentBeanFactory();
                return DwrNamespaceHandler.findParentDefinition(parentName, (BeanDefinitionRegistry)parentBeanFactory);
            }
        }
        return null;
    }

    protected void parseConverterSettings(ConverterConfig converterConfig, Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if ("dwr:include".equals(child.getNodeName())) {
                converterConfig.addInclude(child.getAttribute("method"));
                continue;
            }
            if ("dwr:exclude".equals(child.getNodeName())) {
                converterConfig.addExclude(child.getAttribute("method"));
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was found: " + node.getNodeName());
        }
    }

    protected static Map<String, RuntimeBeanReference> lookupCreators(BeanDefinitionRegistry registry) {
        BeanDefinition config = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("creators").getValue();
    }

    protected static Map<String, ConverterConfig> lookupConverters(BeanDefinitionRegistry registry) {
        BeanDefinition config = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("converters").getValue();
    }

    protected class SignaturesBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected SignaturesBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition config = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(registry);
            StringBuffer sigtext = new StringBuffer();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    log.warn((Object)("Ignoring illegal node type: " + child.getNodeType()));
                    continue;
                }
                sigtext.append(child.getNodeValue());
            }
            config.getPropertyValues().addPropertyValue("signatures", (Object)sigtext.toString());
            return definition;
        }
    }

    protected class CreatorBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected CreatorBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String javascript = element.getAttribute("javascript");
            String creatorType = element.getAttribute("type");
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
            HashMap<String, String> params = new HashMap<String, String>();
            if ("spring".equals(creatorType)) {
                BeanDefinitionBuilder springCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
                springCreator.addPropertyValue("javascript", (Object)javascript);
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() == 3 || childNode.getNodeType() == 8) continue;
                    Element child = (Element)childNode;
                    String paramName = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    if ("beanName".equals(paramName) || "beanId".equals(paramName)) {
                        springCreator.addPropertyValue("beanId", (Object)value);
                        continue;
                    }
                    params.put(paramName, value);
                }
                creatorConfig.addPropertyValue("creator", (Object)springCreator.getBeanDefinition());
            } else if ("new".equals(creatorType)) {
                BeanDefinitionBuilder creator = BeanDefinitionBuilder.rootBeanDefinition(NewCreator.class);
                creator.addPropertyValue("className", (Object)node.getAttributes().getNamedItem(DwrNamespaceHandler.ATTRIBUTE_CLASS).getNodeValue());
                creator.addPropertyValue("javascript", (Object)javascript);
                creatorConfig.addPropertyValue("creator", (Object)creator.getBeanDefinition());
            } else if ("null".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)"none");
                String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                if (className == null || "".equals(className)) {
                    throw new BeanInitializationException("'class' is a required attribute for the declaration <dwr:creator type=\"null\" javascript=\"" + javascript + "\" ... />");
                }
                params.put(DwrNamespaceHandler.ATTRIBUTE_CLASS, className);
            } else if ("pageflow".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)creatorType);
            } else if ("jsf".equals(creatorType) || "scripted".equals(creatorType) || "struts".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)creatorType);
            } else {
                BeanDefinition configurator;
                PropertyValue registeredCreators;
                Map registeredCreatorMap;
                String creatorClass;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking up creator type '" + creatorType + "'"));
                }
                if ((creatorClass = (String)(registeredCreatorMap = (Map)(registeredCreators = (configurator = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(parserContext.getRegistry())).getPropertyValues().getPropertyValue("creatorTypes")).getValue()).get(creatorType)) == null) {
                    throw new UnsupportedOperationException("Type " + creatorType + " is not supported " + " or the custom creator has not been registered dwr:init");
                }
                try {
                    Class<?> clazz = Class.forName(creatorClass);
                    BeanDefinitionBuilder creator = BeanDefinitionBuilder.rootBeanDefinition(clazz);
                    creatorConfig.addPropertyValue("creator", (Object)creator.getBeanDefinition());
                    String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    if (StringUtils.hasText((String)className)) {
                        params.put(DwrNamespaceHandler.ATTRIBUTE_CLASS, className);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new FatalBeanException("ClassNotFoundException trying to register  creator '" + creatorClass + "' for javascript type '" + javascript + "'. Check the " + " class in the classpath and that the creator is register in dwr:init", (Throwable)ex);
                }
            }
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creatorConfig, params, node.getChildNodes());
            return definition;
        }
    }

    protected class InitDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected InitDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node parent, BeanDefinitionHolder definition, ParserContext parserContext) {
            HashMap<String, String> converters = new HashMap<String, String>();
            HashMap<String, String> creators = new HashMap<String, String>();
            NodeList inits = parent.getChildNodes();
            for (int j = 0; j < inits.getLength(); ++j) {
                String className;
                String id;
                Node node = inits.item(j);
                if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
                Element child = (Element)inits.item(j);
                if (child.getNodeName().equals(DwrNamespaceHandler.ELEMENT_CREATOR)) {
                    id = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
                    className = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    creators.put(id, className);
                    continue;
                }
                if (child.getNodeName().equals(DwrNamespaceHandler.ELEMENT_CONVERTER)) {
                    id = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
                    className = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    converters.put(id, className);
                    continue;
                }
                throw new RuntimeException("An unknown sub node '" + child.getNodeName() + "' was found while parsing dwr:init");
            }
            BeanDefinition configurator = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(parserContext.getRegistry());
            configurator.getPropertyValues().addPropertyValue("creatorTypes", creators);
            configurator.getPropertyValues().addPropertyValue("converterTypes", converters);
            return definition;
        }
    }

    protected class ConverterBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected ConverterBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String type = element.getAttribute("type");
            if ("preconfigured".equals(type)) {
                type = type + ":" + element.getAttribute("ref");
            }
            String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
            String javascriptClassName = element.getAttribute("javascript");
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            ConverterConfig converterConfig = new ConverterConfig();
            converterConfig.setType(type);
            converterConfig.setJavascriptClassName(javascriptClassName);
            DwrNamespaceHandler.this.parseConverterSettings(converterConfig, element);
            DwrNamespaceHandler.lookupConverters(registry).put(className, converterConfig);
            return definition;
        }
    }

    protected class RemoteBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected RemoteBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String javascript = element.getAttribute("javascript");
            BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
            try {
                String beanClassName = DwrNamespaceHandler.resolveBeanClassname(definition.getBeanDefinition(), parserContext.getRegistry());
                if (beanClassName == null) {
                    throw new FatalBeanException("Unabled to find type for beanName '" + definition.getBeanName() + "'. " + "Check your bean has a correctly configured parent or provide a class for " + " the bean definition");
                }
                beanCreator.addPropertyValue("beanClass", (Object)ClassUtils.forName((String)beanClassName));
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("Unable to create DWR bean creator for '" + definition.getBeanName() + "'.", (Throwable)e);
            }
            String name = definition.getBeanName();
            if (name.startsWith("scopedTarget.")) {
                name = name.substring(name.indexOf(".") + 1);
            }
            beanCreator.addPropertyValue("beanId", (Object)name);
            if (!StringUtils.hasText((String)javascript)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No javascript name provided. Remoting using bean id [" + name + "]"));
                }
                javascript = StringUtils.capitalize((String)name);
            }
            beanCreator.addPropertyValue("javascript", (Object)javascript);
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
            creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creatorConfig, new HashMap<String, String>(), node.getChildNodes());
            return definition;
        }
    }

    protected class ProxyBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ProxyBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            String beanRef = element.getAttribute("bean");
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition beanRefDefinition = DwrNamespaceHandler.findParentDefinition(beanRef, registry);
            String javascript = element.getAttribute("javascript");
            if (!StringUtils.hasText((String)javascript)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No javascript name provided. Remoting using bean id [" + beanRef + "]"));
                }
                javascript = StringUtils.capitalize((String)beanRef);
            }
            BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
            beanCreator.addPropertyValue("beanClass", (Object)DwrNamespaceHandler.resolveBeanClassname(beanRefDefinition, registry));
            beanCreator.addPropertyValue("beanId", (Object)beanRef);
            beanCreator.addDependsOn(beanRef);
            beanCreator.addPropertyValue("javascript", (Object)javascript);
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
            creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creatorConfig, new HashMap<String, String>(), element.getChildNodes());
            return creatorConfig.getBeanDefinition();
        }
    }

    protected class UrlMappingBeanDefinitionParser
    implements BeanDefinitionParser {
        protected UrlMappingBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(DwrHandlerMapping.class);
            parserContext.getRegistry().registerBeanDefinition("DwrAnnotationURLMapper", (BeanDefinition)builder.getBeanDefinition());
            return parserContext.getRegistry().getBeanDefinition("DwrAnnotationURLMapper");
        }
    }

    protected static class ControllerBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ControllerBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder dwrController = BeanDefinitionBuilder.rootBeanDefinition(DwrController.class);
            ManagedList configurators = new ManagedList();
            configurators.add(new RuntimeBeanReference(DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID));
            dwrController.addPropertyValue("configurators", (Object)configurators);
            String debug = element.getAttribute("debug");
            if (StringUtils.hasText((String)debug)) {
                dwrController.addPropertyValue("debug", (Object)debug);
            }
            String beanName = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
            String nameAttr = element.getAttribute("name");
            String[] aliases = null;
            if (!StringUtils.hasText((String)beanName)) {
                beanName = element.getAttribute("name");
                if (!StringUtils.hasText((String)beanName)) {
                    beanName = "dwrController";
                }
            } else {
                String aliasName = element.getAttribute("name");
                if (StringUtils.hasText((String)aliasName)) {
                    aliases = StringUtils.tokenizeToStringArray((String)nameAttr, (String)",; ");
                }
            }
            this.parseControllerParameters(dwrController, element);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)dwrController.getBeanDefinition(), beanName, aliases);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            return dwrController.getBeanDefinition();
        }

        protected void parseControllerParameters(BeanDefinitionBuilder dwrControllerDefinition, Element parent) {
            NodeList children = parent.getChildNodes();
            HashMap<String, String> params = new HashMap<String, String>();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
                Element child = (Element)node;
                if ("dwr:config-param".equals(child.getNodeName())) {
                    String paramName = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    params.put(paramName, value);
                    continue;
                }
                throw new RuntimeException("an unknown dwr:controller sub node was found: " + node.getNodeName());
            }
            dwrControllerDefinition.addPropertyValue("configParams", params);
        }
    }

    protected class ConfigurationBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ConfigurationBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition beanDefinition = DwrNamespaceHandler.registerSpringConfiguratorIfNecessary(registry);
            Element initElement = DomUtils.getChildElementByTagName((Element)element, (String)"init");
            if (initElement != null) {
                DwrNamespaceHandler.this.decorate(initElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List createElements = DomUtils.getChildElementsByTagName((Element)element, (String)"create");
            for (Element createElement : createElements) {
                DwrNamespaceHandler.this.decorate(createElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List convertElements = DomUtils.getChildElementsByTagName((Element)element, (String)"convert");
            for (Element convertElement : convertElements) {
                DwrNamespaceHandler.this.decorate(convertElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List signatureElements = DomUtils.getChildElementsByTagName((Element)element, (String)"signatures");
            for (Element signatureElement : signatureElements) {
                DwrNamespaceHandler.this.decorate(signatureElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            return beanDefinition;
        }
    }
}

