/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.annotations.RemoteProperty;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.DwrAnnotationPostProcessor;
import org.directwebremoting.spring.DwrNamespaceHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DwrClassPathBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private static final Log log = LogFactory.getLog(DwrClassPathBeanDefinitionScanner.class);

    public DwrClassPathBeanDefinitionScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Repository.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Controller.class));
        this.setScopedProxyMode(ScopedProxyMode.INTERFACES);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        block13: {
            try {
                Class beanDefinitionClass = ClassUtils.forName((String)definitionHolder.getBeanDefinition().getBeanClassName());
                RemoteProxy proxy = beanDefinitionClass.getAnnotation(RemoteProxy.class);
                DataTransferObject converter = beanDefinitionClass.getAnnotation(DataTransferObject.class);
                if (proxy != null) {
                    super.registerBeanDefinition(definitionHolder, registry);
                    String javascript = proxy.name();
                    if (!StringUtils.hasText((String)javascript)) {
                        javascript = beanDefinitionClass.getSimpleName();
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dwr classpath scanning detected candidate bean [" + definitionHolder.getBeanName() + "]. Remoting using " + javascript));
                    }
                    DwrAnnotationPostProcessor.registerCreator(definitionHolder, registry, beanDefinitionClass, javascript);
                } else if (converter != null) {
                    Param[] params;
                    String javascript;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dwr classpath scanning detected candidate DTO [" + beanDefinitionClass.getName() + "] processed by converter type [" + converter.type() + "]"));
                    }
                    ConverterConfig converterConfig = new ConverterConfig();
                    converterConfig.setType(converter.type());
                    PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors((Class)beanDefinitionClass);
                    if (properties != null && properties.length > 0) {
                        for (PropertyDescriptor p : properties) {
                            Method getter = p.getReadMethod();
                            if (getter == null || getter.getAnnotation(RemoteProperty.class) == null) continue;
                            converterConfig.addInclude(p.getName());
                        }
                    }
                    if (StringUtils.hasText((String)(javascript = converter.javascript()))) {
                        converterConfig.setJavascriptClassName(javascript);
                    }
                    if ((params = converter.params()) != null && params.length > 0) {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        for (Param param : params) {
                            parameters.put(param.name(), param.value());
                        }
                        converterConfig.setParams(parameters);
                    }
                    DwrNamespaceHandler.lookupConverters(registry).put(beanDefinitionClass.getName(), converterConfig);
                }
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) break block13;
                log.warn((Object)("Dwr classpath scanning detected candidate bean [" + definitionHolder.getBeanName() + "] but could not create needed proxies"), (Throwable)ex);
            }
        }
    }
}

