/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.spring.DwrAnnotationPostProcessor;
import org.directwebremoting.spring.DwrClassPathBeanDefinitionScanner;
import org.directwebremoting.spring.DwrNamespaceHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DwrAnnotationNamespaceHandler
extends DwrNamespaceHandler {
    private static final Log log = LogFactory.getLog(DwrAnnotationNamespaceHandler.class);

    public void init() {
        super.init();
        this.registerBeanDefinitionParser("annotation-config", new AnnotationConfigBeanDefinitionParser());
        this.registerBeanDefinitionParser("annotation-scan", new AnnotationScannerDefinitionParser());
    }

    protected class AnnotationScannerDefinitionParser
    implements BeanDefinitionParser {
        private boolean scanProxies = true;
        private boolean scanConverters = true;

        protected AnnotationScannerDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            String conv;
            String proxies;
            String regex;
            DwrClassPathBeanDefinitionScanner scanner = new DwrClassPathBeanDefinitionScanner(parserContext.getRegistry());
            String basePackage = element.getAttribute("base-package");
            if (!StringUtils.hasText((String)basePackage) && log.isInfoEnabled()) {
                log.info((Object)"No base package defined for classpath scanning. Traversing the whole JVM classpath");
            }
            if (StringUtils.hasText((String)(regex = element.getAttribute("regex")))) {
                scanner.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(regex)));
            }
            if (StringUtils.hasText((String)(proxies = element.getAttribute("scanRemoteProxy"))) && ("TRUE".equals(proxies.toUpperCase()) || "FALSE".equals(proxies.toUpperCase()))) {
                this.scanProxies = Boolean.parseBoolean(proxies);
            }
            if (this.scanProxies) {
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RemoteProxy.class));
            }
            if (StringUtils.hasText((String)(conv = element.getAttribute("scanDataTransferObject"))) && ("TRUE".equals(conv.toUpperCase()) || "FALSE".equals(conv.toUpperCase()))) {
                this.scanConverters = Boolean.parseBoolean(conv);
            }
            if (this.scanConverters) {
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DataTransferObject.class));
            }
            if (this.scanProxies | this.scanConverters) {
                scanner.scan(new String[]{basePackage == null ? "" : basePackage});
            } else {
                log.warn((Object)"Scan is not required if both @RemoteProxy and @DataTransferObject are disabled. Skipping detection");
            }
            return null;
        }
    }

    protected class AnnotationConfigBeanDefinitionParser
    implements BeanDefinitionParser {
        protected AnnotationConfigBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(DwrAnnotationPostProcessor.class);
            parserContext.getRegistry().registerBeanDefinition("dwrAnnotationPostProcessor", (BeanDefinition)builder.getBeanDefinition());
            return parserContext.getRegistry().getBeanDefinition("dwrAnnotationPostProcessor");
        }
    }
}

