/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Compressor;
import org.directwebremoting.servlet.TemplateHandler;

public abstract class JavaScriptHandler
extends TemplateHandler {
    private Compressor compressor;
    private boolean debug = false;
    private static final Log log = LogFactory.getLog(JavaScriptHandler.class);

    public JavaScriptHandler() {
        this.setMimeType("text/javascript; charset=utf-8");
    }

    protected String generateCachableContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output = super.generateCachableContent(request, response);
        if (this.debug || this.compressor == null) {
            return output;
        }
        try {
            return this.compressor.compressJavaScript(output);
        }
        catch (Exception ex) {
            log.warn((Object)("Compression system (" + this.compressor.getClass().getSimpleName() + ") failed to compress script"), (Throwable)ex);
            return output;
        }
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

