/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.servlet.GeneratedJavaScriptHandler;
import org.directwebremoting.util.LocalUtil;

public class InterfaceHandler
extends GeneratedJavaScriptHandler {
    protected String interfaceHandlerUrl;
    protected String generateDtoClasses;
    private static final Log log = LogFactory.getLog(InterfaceHandler.class);

    protected String generateTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String scriptName = request.getPathInfo();
        if (!scriptName.endsWith(".js")) {
            response.sendError(404);
            return "";
        }
        scriptName = scriptName.replace(this.interfaceHandlerUrl, "");
        if (!LocalUtil.isJavaIdentifier(scriptName = scriptName.replace(".js", ""))) {
            log.debug((Object)("Throwing at request for script with name: '" + scriptName + "'"));
            throw new SecurityException("Script names may only contain Java Identifiers");
        }
        String contextServletPath = request.getContextPath() + request.getServletPath();
        return this.remoter.generateInterfaceScript(scriptName, this.generateDtoClasses.matches(".*\\binterface\\b.*"), contextServletPath);
    }

    public void setInterfaceHandlerUrl(String interfaceHandlerUrl) {
        this.interfaceHandlerUrl = interfaceHandlerUrl;
    }

    public void setGenerateDtoClasses(String generateDtoClasses) {
        this.generateDtoClasses = generateDtoClasses;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.interfaceHandlerUrl + ")";
    }
}

