/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.servlet.GeneratedJavaScriptHandler;
import org.directwebremoting.util.LocalUtil;

public class DtoHandler
extends GeneratedJavaScriptHandler {
    protected String dtoHandlerUrl;
    protected String generateDtoClasses;
    private static final Log log = LogFactory.getLog(DtoHandler.class);

    protected String generateTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.generateDtoClasses.matches(".*\\bdto\\b.*")) {
            response.sendError(404);
            return "";
        }
        String jsClassName = request.getPathInfo();
        if (!jsClassName.startsWith(this.dtoHandlerUrl) || !jsClassName.endsWith(".js")) {
            response.sendError(404);
            return "";
        }
        jsClassName = jsClassName.substring(this.dtoHandlerUrl.length());
        if (!LocalUtil.isJavaIdentifierWithPackage(jsClassName = jsClassName.substring(0, jsClassName.length() - ".js".length()))) {
            log.debug((Object)("Throwing at request for class with name: '" + jsClassName + "'"));
            throw new SecurityException("Class names must comply with Java package and class identifiers");
        }
        return this.remoter.generateDtoScript(jsClassName);
    }

    public void setDtoHandlerUrl(String dtoHandlerUrl) {
        this.dtoHandlerUrl = dtoHandlerUrl;
    }

    public void setGenerateDtoClasses(String generateDtoClasses) {
        this.generateDtoClasses = generateDtoClasses;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.dtoHandlerUrl + ")";
    }
}

