/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.io.OutputStreamLoader;
import org.directwebremoting.util.LocalUtil;

public class DownloadHandler
implements Handler {
    private DownloadManager downloadManager;
    protected String downloadHandlerUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileTransfer transfer;
        String id = request.getPathInfo();
        if (!id.startsWith(this.downloadHandlerUrl)) {
            response.sendError(404);
        }
        if ((transfer = this.downloadManager.getFileTransfer(id = id.substring(this.downloadHandlerUrl.length()))) == null) {
            response.sendError(404);
        } else {
            String filename = transfer.getFilename();
            if (filename != null) {
                response.setHeader("Content-disposition", "attachment; filename=" + filename);
            }
            response.setContentType(transfer.getMimeType());
            OutputStreamLoader loader = null;
            try {
                loader = transfer.getOutputStreamLoader();
                loader.load((OutputStream)response.getOutputStream());
            }
            finally {
                LocalUtil.close(loader);
            }
        }
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }
}

