/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Handler;

public abstract class CachingHandler
implements Handler {
    private String mimeType;
    private final Map<String, CachedResource> scriptCache = new HashMap<String, CachedResource>();
    private boolean ignoreLastModified = false;
    private static final Log log = LogFactory.getLog(CachingHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CachedResource resource;
        long lastModified = this.getLastModifiedTime();
        if (this.isUpToDate(request, lastModified)) {
            response.setStatus(304);
            return;
        }
        Map<String, CachedResource> map = this.scriptCache;
        synchronized (map) {
            String url = request.getPathInfo();
            resource = this.scriptCache.get(url);
            if (resource == null || lastModified > resource.lastModifiedTime) {
                if (log.isDebugEnabled()) {
                    if (resource == null) {
                        log.debug((Object)("Generating contents for " + url + ". It is not currently cached."));
                    } else {
                        log.debug((Object)("Generating contents for " + url + ". Resource modtime=" + lastModified + ". Cached modtime"));
                    }
                }
                resource = new CachedResource();
                resource.contents = this.generateCachableContent(request, response);
                resource.lastModifiedTime = lastModified;
                this.scriptCache.put(url, resource);
            }
        }
        response.setContentType(this.mimeType);
        response.setDateHeader("Last-Modified", lastModified);
        response.setHeader("ETag", "\"" + lastModified + '\"');
        PrintWriter out = response.getWriter();
        out.println(resource.contents);
    }

    protected abstract long getLastModifiedTime();

    protected abstract String generateCachableContent(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected boolean isUpToDate(HttpServletRequest req, long lastModified) {
        String etag = "\"" + lastModified + '\"';
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        String givenEtag = req.getHeader("If-None-Match");
        String pathInfo = req.getPathInfo();
        if (givenEtag == null) {
            if (modifiedSince >= lastModified) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + pathInfo + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + lastModified));
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + pathInfo + ", If-Modified-Since=-1, Old ETag=" + givenEtag + ", New ETag=" + etag));
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince >= lastModified) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending 304 for " + pathInfo + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
            }
            return true;
        }
        log.debug((Object)("Sending content for " + pathInfo + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
        return false;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    class CachedResource {
        protected String contents;
        protected long lastModifiedTime;

        CachedResource() {
        }
    }
}

