/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.tomcat;

import java.io.IOException;
import org.apache.catalina.CometEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Sleeper;

public class TomcatSleeper
implements Sleeper {
    private final CometEvent event;
    private final Object wakeUpCalledLock = new Object();
    private boolean wakeUpCalled = false;
    private Runnable onAwakening;
    private static final Log log = LogFactory.getLog(TomcatSleeper.class);

    public TomcatSleeper(CometEvent event) {
        this.event = event;
        event.getHttpServletRequest().setAttribute("org.directwebremoting.server.tomcat.event", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(Runnable awakening) {
        this.onAwakening = awakening;
        this.event.getHttpServletRequest().setAttribute("org.directwebremoting.server.tomcat.sleep", (Object)true);
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                this.onAwakening.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                return;
            }
            this.wakeUpCalled = true;
            if (this.onAwakening != null) {
                this.onAwakening.run();
            }
            try {
                this.event.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Error while closing the event", (Throwable)ex);
            }
        }
    }
}

