/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.tomcat;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.directwebremoting.servlet.DwrServlet;

public class DwrCometProcessor
extends DwrServlet
implements CometProcessor {
    protected static final String ATTRIBUTE_EVENT = "org.directwebremoting.server.tomcat.event";
    protected static final String ATTRIBUTE_SLEEP = "org.directwebremoting.server.tomcat.sleep";
    protected static final String ATTRIBUTE_ENABLED = "org.directwebremoting.server.tomcat.enabled";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        servletConfig.getServletContext().setAttribute(ATTRIBUTE_ENABLED, (Object)true);
    }

    public void event(CometEvent event) throws IOException, ServletException {
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            event.getHttpServletRequest().setAttribute(ATTRIBUTE_EVENT, (Object)event);
            this.service(event.getHttpServletRequest(), event.getHttpServletResponse());
            Object sleep = event.getHttpServletRequest().getAttribute(ATTRIBUTE_SLEEP);
            if (sleep == null) {
                event.close();
            }
        } else if (event.getEventType() == CometEvent.EventType.ERROR || event.getEventType() == CometEvent.EventType.END) {
            event.close();
        }
    }
}

