/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.grizzly;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.ThreadWaitSleeper;
import org.directwebremoting.util.Continuation;

public class GrizzlyContinuationSleeper
implements Sleeper {
    private Object wakeUpCalledLock = new Object();
    private boolean wakeUpCalled = false;
    protected ThreadWaitSleeper proxy = null;
    protected Runnable onAwakening;
    protected final Continuation continuation;
    protected boolean resumed = false;
    private static final Log log = LogFactory.getLog(GrizzlyContinuationSleeper.class);

    public GrizzlyContinuationSleeper(HttpServletRequest request) {
        this.continuation = new Continuation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(Runnable awakening) {
        this.onAwakening = awakening;
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                this.onAwakening.run();
            } else {
                try {
                    this.continuation.suspend(-1L);
                }
                catch (Exception ex) {
                    Continuation.rethrowIfContinuation(ex);
                    log.warn((Object)"Exception", (Throwable)ex);
                    this.proxy = new ThreadWaitSleeper();
                    this.proxy.goToSleep(this.onAwakening);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                return;
            }
            this.wakeUpCalled = true;
            if (this.proxy != null) {
                this.proxy.wakeUp();
            } else {
                Continuation continuation = this.continuation;
                synchronized (continuation) {
                    if (!this.resumed) {
                        try {
                            this.onAwakening.run();
                            this.continuation.resume();
                        }
                        catch (Exception ex) {
                            log.error((Object)"Broken reflection", (Throwable)ex);
                        }
                        this.resumed = true;
                    }
                }
            }
        }
    }
}

