/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.grizzly;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.ThreadDroppingServerLoadMonitor;
import org.directwebremoting.server.grizzly.GrizzlyContinuationSleeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyContainerAbstraction
implements ContainerAbstraction {
    @Override
    public boolean isNativeEnvironment(ServletConfig servletConfig) {
        String serverInfo = servletConfig.getServletContext().getServerInfo();
        return serverInfo.startsWith("Sun Java System Application Server ");
    }

    @Override
    public Class<? extends ServerLoadMonitor> getServerLoadMonitorImplementation() {
        return ThreadDroppingServerLoadMonitor.class;
    }

    @Override
    public boolean isResponseCompleted(HttpServletRequest request) {
        return false;
    }

    @Override
    public Sleeper createSleeper(HttpServletRequest request) {
        return new GrizzlyContinuationSleeper(request);
    }
}

