/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jsonrpc;

import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.json.JsonUtil;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.JsonParser;
import org.directwebremoting.json.parse.JsonParserFactory;
import org.directwebremoting.jsonrpc.io.JsonRpcCallException;
import org.directwebremoting.jsonrpc.io.JsonRpcCalls;
import org.directwebremoting.jsonrpc.io.JsonRpcCallsJsonDecoder;
import org.directwebremoting.jsonrpc.io.JsonRpcError;
import org.directwebremoting.jsonrpc.io.JsonRpcResponse;

public class JsonRpcCallHandler
implements Handler {
    protected ConverterManager converterManager = null;
    protected boolean jsonRpcEnabled = false;
    protected Remoter remoter = null;
    protected AccessControl accessControl = null;
    protected CreatorManager creatorManager = null;
    private static final Log log = LogFactory.getLog(JsonRpcCallHandler.class);

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.jsonRpcEnabled) {
            log.warn((Object)"JSON-RPC request denied. To enable JSON mode add an init-param of jsonRpcEnabled=true to web.xml");
            throw new SecurityException("JSON interface disabled");
        }
        JsonRpcCalls calls = null;
        try {
            BufferedReader in = request.getReader();
            JsonParser parser = JsonParserFactory.get();
            calls = (JsonRpcCalls)parser.parse(in, new JsonRpcCallsJsonDecoder(this.converterManager, this.creatorManager));
            if (calls.getCallCount() != 1) {
                JsonRpcError error = new JsonRpcError(calls, "Non unique call", -32603, null);
                this.writeResponse(error, response, 500);
                return;
            }
            if (!calls.isParseErrorClean()) {
                JsonRpcError error = new JsonRpcError(calls, calls.getParseErrors(), -32700, null);
                this.writeResponse(error, response, 500);
                return;
            }
            for (Call c : calls) {
                Creator creator = this.creatorManager.getCreator(c.getScriptName(), true);
                this.accessControl.assertExecutionIsPossible(creator, c.getScriptName(), c.getMethod());
            }
            Replies replies = this.remoter.execute(calls);
            Reply reply = replies.getReply(0);
            if (reply.getThrowable() != null) {
                Throwable ex = reply.getThrowable();
                JsonRpcError error = new JsonRpcError(calls, ex.getMessage(), -32000, null);
                this.writeResponse(error, response, 500);
                return;
            }
            JsonRpcResponse answer = new JsonRpcResponse(calls.getVersion(), calls.getId(), reply.getReply());
            this.writeResponse(answer, response, 200);
        }
        catch (JsonRpcCallException ex) {
            this.writeResponse(new JsonRpcError(ex), response, ex.getHttpStatusCode());
            return;
        }
        catch (JsonParseException ex) {
            JsonRpcError error = new JsonRpcError("2.0", null, ex.getMessage(), -32700, null);
            this.writeResponse(error, response, 500);
            return;
        }
        catch (SecurityException ex) {
            JsonRpcError error = new JsonRpcError(calls, ex.getMessage(), -32601, null);
            this.writeResponse(error, response, 404);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Object)"Unexpected error:", (Throwable)ex);
            JsonRpcError error = new JsonRpcError(calls, ex.getMessage(), -32000, null);
            this.writeResponse(error, response, 500);
        }
    }

    protected void writeResponse(Object data, HttpServletResponse response, int httpStatus) throws IOException {
        response.setContentType("application/json");
        response.setStatus(httpStatus);
        JsonUtil.toJson(data, response.getWriter());
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setJsonRpcEnabled(boolean jsonRpcEnabled) {
        this.jsonRpcEnabled = jsonRpcEnabled;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }
}

