/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.directwebremoting.extend.InputStreamFactoryOutputStreamLoader;
import org.directwebremoting.extend.OutputStreamLoaderInputStreamFactory;
import org.directwebremoting.extend.SimpleInputStreamFactory;
import org.directwebremoting.io.InputStreamFactory;
import org.directwebremoting.io.OutputStreamLoader;
import org.directwebremoting.util.CopyUtils;

public class FileTransfer {
    private final String filename;
    private final String mimeType;
    private final long size;
    private final OutputStreamLoader outputStreamLoader;
    private final InputStreamFactory inputStreamFactory;

    public FileTransfer(String filename, String mimeType, OutputStreamLoader outputStreamLoader) {
        this.filename = filename;
        this.mimeType = mimeType;
        this.outputStreamLoader = outputStreamLoader;
        this.size = -1L;
        this.inputStreamFactory = null;
    }

    public FileTransfer(BufferedImage image, String type) {
        this(image, "image", type);
    }

    public FileTransfer(final BufferedImage image, String filename, final String type) {
        this.filename = filename;
        this.mimeType = "image/" + type;
        this.outputStreamLoader = new OutputStreamLoader(){

            public void load(OutputStream out) throws IOException {
                ImageIO.write((RenderedImage)image, type, out);
            }

            public void close() throws IOException {
            }
        };
        this.size = -1L;
        this.inputStreamFactory = null;
    }

    public FileTransfer(String filename, String mimeType, final byte[] bytes) {
        this.filename = filename;
        this.mimeType = mimeType;
        this.size = bytes.length;
        this.outputStreamLoader = new OutputStreamLoader(){

            public void load(OutputStream out) throws IOException {
                CopyUtils.copy(bytes, out);
            }

            public void close() throws IOException {
            }
        };
        this.inputStreamFactory = null;
    }

    public FileTransfer(String filename, String mimeType, long size, InputStreamFactory inputStreamFactory) {
        this.filename = filename;
        this.mimeType = mimeType;
        this.size = size;
        this.outputStreamLoader = null;
        this.inputStreamFactory = inputStreamFactory;
    }

    public FileTransfer(String filename, String mimeType, long size, InputStream in) {
        this.filename = filename;
        this.mimeType = mimeType;
        this.size = size;
        this.outputStreamLoader = null;
        this.inputStreamFactory = new SimpleInputStreamFactory(in, true);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public OutputStreamLoader getOutputStreamLoader() {
        if (this.outputStreamLoader != null) {
            return this.outputStreamLoader;
        }
        return new InputStreamFactoryOutputStreamLoader(this.inputStreamFactory);
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamFactory != null) {
            return this.inputStreamFactory.getInputStream();
        }
        return new OutputStreamLoaderInputStreamFactory(this.outputStreamLoader).getInputStream();
    }
}

