/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.event.ScriptSessionBindingEvent;
import org.directwebremoting.event.ScriptSessionBindingListener;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.TransientScriptSessionManager;
import org.directwebremoting.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientScriptSession
implements RealScriptSession {
    private static IdGenerator generator = new IdGenerator();
    protected final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    protected final SortedSet<ScriptConduit> conduits = new TreeSet<ScriptConduit>();
    protected final List<ScriptBuffer> scripts = new ArrayList<ScriptBuffer>();
    private final Object scriptLock = new Object();
    protected final String page;
    protected final String scriptSessionId = generator.generateId(16);
    private String windowName;
    protected final TransientScriptSessionManager manager;
    private static final Log log = LogFactory.getLog(TransientScriptSession.class);

    protected TransientScriptSession(TransientScriptSessionManager manager, String page) {
        this.page = page;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                if (value instanceof ScriptSessionBindingListener) {
                    ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                    listener.valueBound(new ScriptSessionBindingEvent(this, name));
                }
                this.attributes.put(name, value);
            } else {
                this.removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object value = this.attributes.remove(name);
            if (value != null && value instanceof ScriptSessionBindingListener) {
                ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                listener.valueUnbound(new ScriptSessionBindingEvent(this, name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getAttributeNames() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Set<String> keys = Collections.unmodifiableSet(this.attributes.keySet());
            return keys.iterator();
        }
    }

    @Override
    public void invalidate() {
        throw new IllegalStateException("TransientScriptSession should not be invalidated");
    }

    @Override
    public boolean isInvalidated() {
        return false;
    }

    @Override
    public String getId() {
        return this.scriptSessionId;
    }

    @Override
    public long getCreationTime() {
        return System.currentTimeMillis();
    }

    @Override
    public long getLastAccessedTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScript(ScriptBuffer script) {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.conduits.isEmpty()) {
                boolean written = false;
                if (!written) {
                    this.scripts.add(script);
                }
            } else {
                boolean written = false;
                Iterator it = this.conduits.iterator();
                while (!written && it.hasNext()) {
                    ScriptConduit conduit = (ScriptConduit)it.next();
                    try {
                        written = conduit.addScript(script);
                    }
                    catch (Exception ex) {
                        it.remove();
                        log.debug((Object)("Failed to write to ScriptConduit, removing conduit from list: " + conduit));
                    }
                }
                if (!written) {
                    this.scripts.add(script);
                }
            }
        }
    }

    @Override
    public boolean addScriptImmediately(ScriptBuffer script) {
        return false;
    }

    @Override
    public int countPersistentConnections() {
        int persistentConnections = 0;
        for (ScriptConduit conduit : this.conduits) {
            if (!conduit.isHoldingConnectionToBrowser()) continue;
            ++persistentConnections;
        }
        return persistentConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScriptConduit(ScriptConduit conduit) throws IOException {
        Object object = this.scriptLock;
        synchronized (object) {
            this.writeScripts(conduit);
            this.conduits.add(conduit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeScripts(ScriptConduit conduit) throws IOException {
        Object object = this.scriptLock;
        synchronized (object) {
            Iterator<ScriptBuffer> it = this.scripts.iterator();
            while (it.hasNext()) {
                ScriptBuffer script = it.next();
                try {
                    if (!conduit.addScript(script)) break;
                    it.remove();
                }
                catch (ConversionException ex) {
                    log.error((Object)("Failed to convert data. Dropping Javascript: " + script), (Throwable)ex);
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScriptConduit(ScriptConduit conduit) {
        Object object = this.scriptLock;
        synchronized (object) {
            boolean removed = this.conduits.remove(conduit);
            if (!removed) {
                log.debug((Object)("removeScriptConduit called with ScriptConduit not in our list. conduit=" + conduit));
                this.debug();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWaitingScripts() {
        Object object = this.scriptLock;
        synchronized (object) {
            return !this.scripts.isEmpty();
        }
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public String getWindowName() {
        return this.windowName;
    }

    @Override
    public void updateLastAccessedTime() {
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + this.conduits.size() + " ScriptConduits attached to " + this));
            for (ScriptConduit scriptConduit : this.conduits) {
                log.debug((Object)("- " + scriptConduit));
            }
        }
    }
}

