/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.IdGenerator;

public abstract class PurgingDownloadManager
implements DownloadManager {
    protected ScheduledThreadPoolExecutor executor = null;
    protected DownloadPurge downloadPurge = new DownloadPurge();
    protected int queueSleepTime = 15000;
    protected long purgeDownloadsAfter = 120000L;
    protected String downloadHandlerUrl;
    protected IdGenerator idGenerator = new IdGenerator();

    public String addFileTransfer(FileTransfer generator) throws IOException {
        String id = this.idGenerator.generateId(16);
        this.putFileTransfer(id, generator);
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        return "'" + request.getContextPath() + request.getServletPath() + this.downloadHandlerUrl + id + "'";
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }

    public void setPurgeDownloadsAfter(long purgeDownloadsAfter) {
        this.purgeDownloadsAfter = purgeDownloadsAfter;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        this.executor.scheduleWithFixedDelay(this.downloadPurge, this.queueSleepTime, this.queueSleepTime, TimeUnit.MILLISECONDS);
    }

    protected abstract void putFileTransfer(String var1, FileTransfer var2);

    protected abstract void purge();

    public class DownloadPurge
    implements Runnable {
        public void run() {
            PurgingDownloadManager.this.purge();
        }
    }
}

