/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.impl.PurgingDownloadManager;
import org.directwebremoting.io.FileTransfer;

public class InMemoryDownloadManager
extends PurgingDownloadManager
implements DownloadManager {
    protected int downloadRequestsBeforeRemove = 1;
    protected final Object contentsLock = new Object();
    protected final Map<String, TimedFileTransfer> contents = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(InMemoryDownloadManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putFileTransfer(String id, FileTransfer transfer) {
        Object object = this.contentsLock;
        synchronized (object) {
            this.contents.put(id, new TimedFileTransfer(transfer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTransfer getFileTransfer(String id) {
        Object object = this.contentsLock;
        synchronized (object) {
            TimedFileTransfer transfer = this.contents.get(id);
            if (transfer == null) {
                return null;
            }
            ++transfer.downloadRequests;
            if (transfer.downloadRequests >= this.downloadRequestsBeforeRemove) {
                this.contents.remove(id);
            }
            return transfer.fileTransfer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge() {
        long now = System.currentTimeMillis();
        Object object = this.contentsLock;
        synchronized (object) {
            Iterator<Map.Entry<String, TimedFileTransfer>> it = this.contents.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TimedFileTransfer> entry = it.next();
                try {
                    if (now <= entry.getValue().timeInserted + this.purgeDownloadsAfter) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    log.warn((Object)("Deletion queue processing error: " + ex.getMessage()));
                }
            }
        }
    }

    public void setDownloadRequestsBeforeRemove(int downloadRequestsBeforeRemove) {
        this.downloadRequestsBeforeRemove = downloadRequestsBeforeRemove;
    }

    protected static class TimedFileTransfer {
        protected final FileTransfer fileTransfer;
        protected final long timeInserted;
        protected int downloadRequests = 0;

        protected TimedFileTransfer(FileTransfer fileTransfer) {
            this.fileTransfer = fileTransfer;
            this.timeInserted = System.currentTimeMillis();
        }
    }
}

