/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.DefaultWebContext;

public class DefaultWebContextBuilder
implements WebContextFactory.WebContextBuilder {
    private static ThreadLocal<WebContext> user = new ThreadLocal();
    private static final Log log = LogFactory.getLog(DefaultWebContextBuilder.class);

    public WebContext get() {
        return user.get();
    }

    public void engageThread(Container container, HttpServletRequest request, HttpServletResponse response) {
        try {
            ServletConfig servletConfig = container.getBean(ServletConfig.class);
            ServletContext servletContext = container.getBean(ServletContext.class);
            DefaultWebContext ec = new DefaultWebContext(container, request, response, servletConfig, servletContext);
            user.set(ec);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to create an ExecutionContext", (Throwable)ex);
        }
    }

    public void disengageThread() {
        user.set(null);
    }
}

