/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.event.ScriptSessionBindingEvent;
import org.directwebremoting.event.ScriptSessionBindingListener;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.DefaultScriptSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptSession
implements RealScriptSession {
    protected final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    private long lastAccessedTime = 0L;
    private volatile boolean invalidated = false;
    private final Object invalidLock = new Object();
    protected final SortedSet<ScriptConduit> conduits = new TreeSet<ScriptConduit>();
    protected final List<ScriptBuffer> scripts = new ArrayList<ScriptBuffer>();
    private final Object scriptLock = new Object();
    protected final String id;
    protected final long creationTime;
    protected final String page;
    private String windowName;
    protected final DefaultScriptSessionManager manager;
    private static final Log log = LogFactory.getLog(DefaultScriptSession.class);

    protected DefaultScriptSession(String id, DefaultScriptSessionManager manager, String page) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.page = page;
        this.manager = manager;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        this.invalidateIfNeeded();
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        this.invalidateIfNeeded();
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                if (value instanceof ScriptSessionBindingListener) {
                    ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                    listener.valueBound(new ScriptSessionBindingEvent(this, name));
                }
                this.attributes.put(name, value);
            } else {
                this.removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        this.invalidateIfNeeded();
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object value = this.attributes.remove(name);
            if (value != null && value instanceof ScriptSessionBindingListener) {
                ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                listener.valueUnbound(new ScriptSessionBindingEvent(this, name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getAttributeNames() {
        this.invalidateIfNeeded();
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Set<String> keys = Collections.unmodifiableSet(this.attributes.keySet());
            return keys.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = this.invalidLock;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof ScriptSessionBindingListener)) continue;
                ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                listener.valueUnbound(new ScriptSessionBindingEvent(this, entry.getKey()));
            }
            this.invalidated = true;
            this.manager.invalidate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInvalidated() {
        Object object = this.invalidLock;
        synchronized (object) {
            return this.invalidated;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        this.invalidateIfNeeded();
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastAccessedTime() {
        Object object = this.invalidLock;
        synchronized (object) {
            return this.lastAccessedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScript(ScriptBuffer script) {
        this.invalidateIfNeeded();
        if (script == null) {
            throw new NullPointerException("null script");
        }
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.conduits.isEmpty()) {
                boolean written = false;
                if (!written) {
                    this.scripts.add(script);
                }
            } else {
                boolean written = false;
                Iterator it = this.conduits.iterator();
                while (!written && it.hasNext()) {
                    ScriptConduit conduit = (ScriptConduit)it.next();
                    try {
                        written = conduit.addScript(script);
                    }
                    catch (Exception ex) {
                        it.remove();
                        log.debug((Object)("Failed to write to ScriptConduit, removing conduit from list: " + conduit));
                    }
                }
                if (!written) {
                    this.scripts.add(script);
                }
            }
        }
    }

    @Override
    public boolean addScriptImmediately(ScriptBuffer script) {
        return false;
    }

    @Override
    public int countPersistentConnections() {
        int persistentConnections = 0;
        for (ScriptConduit conduit : this.conduits) {
            if (!conduit.isHoldingConnectionToBrowser()) continue;
            ++persistentConnections;
        }
        return persistentConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScriptConduit(ScriptConduit conduit) throws IOException {
        this.invalidateIfNeeded();
        Object object = this.scriptLock;
        synchronized (object) {
            this.writeScripts(conduit);
            this.conduits.add(conduit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeScripts(ScriptConduit conduit) throws IOException {
        this.invalidateIfNeeded();
        Object object = this.scriptLock;
        synchronized (object) {
            Iterator<ScriptBuffer> it = this.scripts.iterator();
            while (it.hasNext()) {
                ScriptBuffer script = it.next();
                try {
                    if (!conduit.addScript(script)) break;
                    it.remove();
                }
                catch (ConversionException ex) {
                    log.error((Object)("Failed to convert data. Dropping Javascript: " + script), (Throwable)ex);
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScriptConduit(ScriptConduit conduit) {
        this.invalidateIfNeeded();
        Object object = this.scriptLock;
        synchronized (object) {
            boolean removed = this.conduits.remove(conduit);
            if (!removed) {
                log.debug((Object)("removeScriptConduit called with ScriptConduit not in our list. conduit=" + conduit));
                this.debug();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWaitingScripts() {
        Object object = this.scriptLock;
        synchronized (object) {
            return !this.scripts.isEmpty();
        }
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public String getWindowName() {
        return this.windowName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastAccessedTime() {
        long temp = System.currentTimeMillis();
        Object object = this.invalidLock;
        synchronized (object) {
            this.lastAccessedTime = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateIfNeeded() {
        if (this.invalidated) {
            return;
        }
        long now = System.currentTimeMillis();
        Object object = this.invalidLock;
        synchronized (object) {
            long age = now - this.lastAccessedTime;
            if (age > this.manager.getScriptSessionTimeout()) {
                this.invalidate();
            }
        }
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + this.conduits.size() + " ScriptConduits attached to " + this));
            for (ScriptConduit scriptConduit : this.conduits) {
                log.debug((Object)("- " + scriptConduit));
            }
        }
    }

    public int hashCode() {
        return 572 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultScriptSession that = (DefaultScriptSession)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "DefaultScriptSession[id=" + this.getDebugName() + "]";
    }

    protected String getDebugName() {
        return this.id.substring(0, 4);
    }
}

