/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.filter.LogAjaxFilter;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRemoter
implements Remoter {
    protected boolean givenAuditLogHint = false;
    private boolean debug = false;
    private AjaxFilterManager ajaxFilterManager = null;
    protected CreatorManager creatorManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    protected String overridePath = null;
    protected boolean useAbsolutePath = false;
    protected boolean allowImpossibleTests = false;
    protected int maxCallCount = 20;
    protected Map<String, String> methodCache = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(DefaultRemoter.class);

    @Override
    public String generateInterfaceScript(String scriptName, boolean includeDto, String contextServletPath) throws SecurityException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(EnginePrivate.getEngineInitScript());
        if (includeDto) {
            buffer.append(this.createParameterDefinitions(scriptName));
        }
        buffer.append(this.createDojoProvides(scriptName));
        buffer.append(this.createClassDefinition(scriptName));
        buffer.append(this.createPathDefinition(scriptName, contextServletPath));
        buffer.append(this.createMethodDefinitions(scriptName));
        return buffer.toString();
    }

    @Override
    public String generateDtoScript(String jsClassName) throws SecurityException {
        return this.createDtoClassDefinition(jsClassName, true);
    }

    @Override
    public String generateAllDtoScripts() throws SecurityException {
        return this.createAllDtoClassDefinitions();
    }

    protected String createDojoProvides(String scriptName) {
        return "if (window['dojo']) dojo.provide('dwr.interface." + scriptName + "');\n\n";
    }

    protected String createClassDefinition(String scriptName) {
        return "if (typeof this['" + scriptName + "'] == 'undefined') " + scriptName + " = {};\n\n";
    }

    protected String createPathDefinition(String scriptName, String path) {
        return scriptName + "._path = '" + this.getPathToDwrServlet(path) + "';\n\n";
    }

    @Override
    public String getPathToDwrServlet(String contextServletPath) {
        String actualPath = contextServletPath;
        if (this.overridePath != null) {
            actualPath = this.overridePath;
        }
        if (this.useAbsolutePath) {
            HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
            StringBuffer absolutePath = new StringBuffer(48);
            String scheme = request.getScheme();
            int port = request.getServerPort();
            absolutePath.append(scheme);
            absolutePath.append("://");
            absolutePath.append(request.getServerName());
            if (port > 0 && ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443)) {
                absolutePath.append(':');
                absolutePath.append(port);
            }
            absolutePath.append(request.getContextPath());
            absolutePath.append(request.getServletPath());
            actualPath = absolutePath.toString();
        }
        return actualPath;
    }

    protected String createMethodDefinitions(String fullCreatorName) {
        Method[] methods;
        Creator creator = this.creatorManager.getCreator(fullCreatorName, false);
        String scriptName = creator.getJavascript();
        StringBuilder buffer = new StringBuilder();
        for (Method method : methods = creator.getType().getMethods()) {
            String script;
            String methodName = method.getName();
            try {
                this.accessControl.assertIsDisplayable(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                if (!this.allowImpossibleTests) continue;
            }
            if (JavascriptUtil.isReservedWord(methodName)) continue;
            if (!creator.isCacheable()) {
                script = this.getMethodJS(scriptName, method);
            } else {
                String key = scriptName + "." + method.getName();
                script = this.methodCache.get(key);
                if (script == null) {
                    script = this.getMethodJS(scriptName, method);
                    this.methodCache.put(key, script);
                }
            }
            buffer.append(script);
        }
        return buffer.toString();
    }

    protected String createParameterDefinitions(String scriptName) {
        return this.createAllDtoClassDefinitions();
    }

    protected String createAllDtoClassDefinitions() {
        NamedConverter namedConv;
        String jsClassName;
        Converter conv;
        StringBuilder buffer = new StringBuilder();
        for (String match : this.converterManager.getConverterMatchStrings()) {
            conv = this.converterManager.getConverterByMatchString(match);
            if (!(conv instanceof NamedConverter) || !LocalUtil.hasLength(jsClassName = (namedConv = (NamedConverter)conv).getJavascript())) continue;
            buffer.append(this.createDtoClassDefinition(namedConv));
        }
        for (String match : this.converterManager.getConverterMatchStrings()) {
            conv = this.converterManager.getConverterByMatchString(match);
            if (!(conv instanceof NamedConverter) || !LocalUtil.hasLength(jsClassName = (namedConv = (NamedConverter)conv).getJavascript())) continue;
            buffer.append(this.createDtoSuperClassDefinition(namedConv));
        }
        return buffer.toString();
    }

    protected String createDtoClassDefinition(String jsClassName, boolean setupSuperClass) {
        StringBuilder buf = new StringBuilder();
        for (String match : this.converterManager.getConverterMatchStrings()) {
            NamedConverter namedConv;
            Converter conv = this.converterManager.getConverterByMatchString(match);
            if (!(conv instanceof NamedConverter) || !jsClassName.equals((namedConv = (NamedConverter)conv).getJavascript())) continue;
            buf.append(this.createDtoClassDefinition(namedConv));
            if (setupSuperClass) {
                buf.append(this.createDtoSuperClassDefinition(namedConv));
            }
            return buf.toString();
        }
        log.warn((Object)("Failed to create class definition for JS class " + jsClassName + " because it was not found."));
        buf.append("// Missing mapped class definition for ");
        buf.append(jsClassName);
        buf.append(". See the server logs for details.\n");
        return buf.toString();
    }

    protected String createDtoClassDefinition(NamedConverter namedConv) {
        String jsClassName = namedConv.getJavascript();
        try {
            String name;
            StringBuilder buf = new StringBuilder();
            String[] parts = jsClassName.split("\\.");
            String path = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                String leaf = parts[i];
                buf.append("if (!('");
                buf.append(leaf);
                buf.append("' in this");
                buf.append(path);
                buf.append(")) this");
                buf.append(path);
                buf.append(".");
                buf.append(leaf);
                buf.append(" = {};\n");
                path = path + "." + leaf;
            }
            buf.append("if (typeof this.");
            buf.append(jsClassName);
            buf.append(" != 'function') {\n");
            buf.append("  this.");
            buf.append(jsClassName);
            buf.append(" = function() {\n");
            Map<String, Property> properties = namedConv.getPropertyMapFromClass(namedConv.getInstanceType(), true, true);
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                name = entry.getKey();
                Property property = entry.getValue();
                Class<?> propType = property.getPropertyType();
                buf.append("    this.");
                buf.append(name);
                buf.append(" = ");
                if (propType.isArray()) {
                    buf.append("[]");
                } else if (propType == Boolean.TYPE) {
                    buf.append("false");
                } else if (propType.isPrimitive()) {
                    buf.append("0");
                } else {
                    buf.append("null");
                }
                buf.append(";\n");
            }
            buf.append("  }\n");
            buf.append("  this.");
            buf.append(jsClassName);
            buf.append(".$dwrClassName = '");
            buf.append(jsClassName);
            buf.append("';\n");
            buf.append("  this.");
            buf.append(jsClassName);
            buf.append(".$dwrClassMembers = {};\n");
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                name = entry.getKey();
                buf.append("  this.");
                buf.append(jsClassName);
                buf.append(".$dwrClassMembers.");
                buf.append(name);
                buf.append(" = {};\n");
            }
            buf.append("  this.");
            buf.append(jsClassName);
            buf.append(".createFromMap = function(map) {\n");
            buf.append("    var obj = new this();\n");
            buf.append("    for(prop in map) if (map.hasOwnProperty(prop)) obj[prop] = map[prop];\n");
            buf.append("    return obj;\n");
            buf.append("  }\n");
            buf.append("  dwr.engine._mappedClasses['");
            buf.append(jsClassName);
            buf.append("'] = this.");
            buf.append(jsClassName);
            buf.append(";\n");
            buf.append("}\n");
            buf.append("\n");
            return buf.toString();
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to create class definition for JS class " + jsClassName), (Throwable)ex);
            StringBuilder buf = new StringBuilder();
            buf.append("// Missing mapped class definition for ");
            buf.append(jsClassName);
            buf.append(". See the server logs for details.\n");
            return buf.toString();
        }
    }

    protected String createDtoSuperClassDefinition(NamedConverter namedConv) {
        StringBuilder buf = new StringBuilder();
        if (LocalUtil.hasLength(namedConv.getJavascriptSuperClass())) {
            String subclass = namedConv.getJavascript();
            String superclass = namedConv.getJavascriptSuperClass();
            buf.append(subclass);
            buf.append(".prototype = new ");
            buf.append(superclass);
            buf.append("();\n");
            buf.append(subclass);
            buf.append(".prototype.constructor = ");
            buf.append(subclass);
            buf.append(";\n");
            buf.append("\n");
        }
        return buf.toString();
    }

    protected String getMethodJS(String scriptName, Method method) {
        int j;
        StringBuffer buffer = new StringBuffer();
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        buffer.append("/**\n");
        for (j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) continue;
            buffer.append(" * @param {");
            buffer.append(paramTypes[j]);
            buffer.append("} p");
            buffer.append(j);
            buffer.append(" a param\n");
        }
        buffer.append(" * @param {function|Object} callback callback function or options object\n");
        buffer.append(" */\n");
        buffer.append(scriptName);
        buffer.append('.');
        buffer.append(methodName);
        buffer.append(" = function(");
        for (j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) continue;
            buffer.append("p");
            buffer.append(j);
            buffer.append(", ");
        }
        buffer.append("callback) {\n");
        buffer.append("  return ");
        buffer.append(EnginePrivate.getExecuteFunctionName());
        buffer.append("(");
        buffer.append(scriptName);
        buffer.append("._path, '");
        buffer.append(scriptName);
        buffer.append("', '");
        buffer.append(methodName);
        buffer.append("', arguments);\n");
        buffer.append("};\n\n");
        return buffer.toString();
    }

    @Override
    public Replies execute(Calls calls) {
        Replies replies = new Replies(calls);
        int callCount = calls.getCallCount();
        if (callCount > this.maxCallCount) {
            log.error((Object)"Call count for batch exceeds maxCallCount. Add an init-param of maxCallCount to increase this limit");
            throw new SecurityException("Call count for batch is too high");
        }
        for (Call call : calls) {
            Reply reply = this.execute(call);
            replies.addReply(reply);
        }
        return replies;
    }

    public Reply execute(Call call) {
        List<AjaxFilter> filters = this.ajaxFilterManager.getAjaxFilters(call.getScriptName());
        try {
            Method method = call.getMethod();
            if (method == null || call.getException() != null) {
                return new Reply(call.getCallId(), null, call.getException());
            }
            Creator creator = this.creatorManager.getCreator(call.getScriptName(), true);
            this.accessControl.assertExecutionIsPossible(creator, call.getScriptName(), method);
            Object object = null;
            String scope = creator.getScope();
            boolean create = false;
            if (!Modifier.isStatic(method.getModifiers())) {
                WebContext webcx = WebContextFactory.get();
                if (scope.equals("application")) {
                    object = webcx.getServletContext().getAttribute(call.getScriptName());
                } else if (scope.equals("session")) {
                    object = webcx.getSession().getAttribute(call.getScriptName());
                } else if (scope.equals("script")) {
                    object = webcx.getScriptSession().getAttribute(call.getScriptName());
                } else if (scope.equals("request")) {
                    object = webcx.getHttpServletRequest().getAttribute(call.getScriptName());
                }
                if (object == null) {
                    create = true;
                    object = creator.getInstance();
                }
                if (create) {
                    if (scope.equals("application")) {
                        webcx.getServletContext().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("session")) {
                        webcx.getSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("script")) {
                        webcx.getScriptSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("request")) {
                        webcx.getHttpServletRequest().setAttribute(call.getScriptName(), object);
                    }
                }
            }
            final Iterator<AjaxFilter> it = filters.iterator();
            AjaxFilterChain chain = new AjaxFilterChain(){

                public Object doFilter(Object obj, Method meth, Object[] params) throws Exception {
                    if (it.hasNext()) {
                        AjaxFilter next = (AjaxFilter)it.next();
                        return next.doFilter(obj, meth, params, this);
                    }
                    return meth.invoke(obj, params);
                }
            };
            Object reply = chain.doFilter(object, method, call.getParameters());
            return new Reply(call.getCallId(), reply);
        }
        catch (SecurityException ex) {
            if (!this.filtersIncludeLogging(filters)) {
                log.warn((Object)("Security Exception: " + ex.getMessage()));
            }
            if (this.debug) {
                return new Reply(call.getCallId(), null, ex);
            }
            return new Reply(call.getCallId(), null, new SecurityException());
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowIfContinuation(ex);
            this.debugException(filters, ex.getTargetException());
            return new Reply(call.getCallId(), null, ex.getTargetException());
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            this.debugException(filters, ex);
            return new Reply(call.getCallId(), null, ex);
        }
    }

    private void debugException(List<AjaxFilter> filters, Throwable ex) {
        if (this.debug && !this.filtersIncludeLogging(filters)) {
            if (!this.givenAuditLogHint) {
                log.debug((Object)"No logging filters defined. Minimal execption logging. For more detail add <filter class='org.directwebremoting.filter.AuditLogAjaxFilter'/> to dwr.xml");
                this.givenAuditLogHint = true;
            }
            log.debug((Object)"Method execution failed: ", ex);
        }
    }

    private boolean filtersIncludeLogging(List<AjaxFilter> filters) {
        for (AjaxFilter element : filters) {
            if (!(element instanceof LogAjaxFilter)) continue;
            return true;
        }
        return false;
    }

    public void setUseAbsolutePath(boolean useAbsolutePath) {
        this.useAbsolutePath = useAbsolutePath;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAjaxFilterManager(AjaxFilterManager ajaxFilterManager) {
        this.ajaxFilterManager = ajaxFilterManager;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setMaxCallCount(int maxCallCount) {
        this.maxCallCount = maxCallCount;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

