/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCreatorManager
implements CreatorManager {
    protected Map<String, Class<? extends Creator>> creatorTypes = new HashMap<String, Class<? extends Creator>>();
    protected Map<String, Creator> creators = new HashMap<String, Creator>();
    protected boolean debug = false;
    protected boolean initApplicationScopeCreatorsAtStartup = false;
    protected ServletContext servletContext;
    protected static final List<String> ignore = Arrays.asList("creator", "class");
    private static final Log log = LogFactory.getLog(DefaultCreatorManager.class);

    @Override
    public void addCreatorType(String typeName, String className) {
        if (!LocalUtil.isJavaIdentifier(typeName)) {
            Loggers.STARTUP.error((Object)("Illegal identifier: '" + typeName + "'"));
            return;
        }
        Class<Creator> clazz = LocalUtil.classForName(typeName, className, Creator.class);
        if (clazz != null) {
            Loggers.STARTUP.debug((Object)("- adding creator type: " + typeName + " = " + clazz));
            this.creatorTypes.put(typeName, clazz);
        }
    }

    @Override
    public void addCreator(String scriptName, String creatorName, Map<String, String> params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        Class<? extends Creator> clazz = this.creatorTypes.get(creatorName);
        if (clazz == null) {
            Loggers.STARTUP.error((Object)("Missing creator: " + creatorName + " (while initializing creator for: " + scriptName + ".js)"));
            return;
        }
        Creator creator = clazz.newInstance();
        LocalUtil.setParams(creator, params, ignore);
        creator.setProperties(params);
        this.addCreator(creator.getJavascript(), creator);
    }

    @Override
    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        Creator other = this.creators.get(scriptName);
        if (other != null) {
            Loggers.STARTUP.error((Object)("Javascript name " + scriptName + " is used by 2 classes (" + other.getType().getName() + " and " + creator + ")"));
            throw new IllegalArgumentException("Duplicate name found. See logs for details.");
        }
        try {
            Class<?> test = creator.getType();
            if (test == null) {
                Loggers.STARTUP.error((Object)("Creator: '" + creator + "' for " + scriptName + ".js is returning null for type queries."));
            } else {
                Loggers.STARTUP.debug((Object)("- adding creator: " + creator.getClass().getSimpleName() + " for " + scriptName));
                this.creators.put(scriptName, creator);
            }
        }
        catch (NoClassDefFoundError ex) {
            Loggers.STARTUP.error((Object)("Missing class for creator '" + creator + "'. Cause: " + ex.getMessage()));
        }
        catch (Exception ex) {
            Loggers.STARTUP.error((Object)("Error loading class for creator '" + creator + "'."), (Throwable)ex);
        }
        if (this.initApplicationScopeCreatorsAtStartup && creator.getScope().equals("application")) {
            try {
                Object object = creator.getInstance();
                this.servletContext.setAttribute(creator.getJavascript(), object);
                Loggers.STARTUP.debug((Object)("Created new " + creator.getJavascript() + ", stored in application."));
            }
            catch (InstantiationException ex) {
                Loggers.STARTUP.warn((Object)("Failed to create " + creator.getJavascript()), (Throwable)ex);
                Loggers.STARTUP.debug((Object)"Maybe it will succeed when the application is in flight. If so you should probably set initApplicationScopeCreatorsAtStartup=false in web.xml");
            }
        }
    }

    @Override
    public Collection<String> getCreatorNames(boolean includeHidden) throws SecurityException {
        if (!this.debug) {
            throw new SecurityException();
        }
        if (includeHidden) {
            return Collections.unmodifiableSet(this.creators.keySet());
        }
        HashSet<String> noHidden = new HashSet<String>();
        for (Map.Entry<String, Creator> entry : this.creators.entrySet()) {
            Creator creator = entry.getValue();
            if (creator.isHidden()) continue;
            noHidden.add(entry.getKey());
        }
        return noHidden;
    }

    @Override
    public Creator getCreator(String scriptName, boolean includeHidden) throws SecurityException {
        Creator creator = this.creators.get(scriptName);
        if (creator == null) {
            StringBuffer buffer = new StringBuffer("Names of known classes are: ");
            for (String key : this.creators.keySet()) {
                buffer.append(key);
                buffer.append(' ');
            }
            log.error((Object)("Class not found: '" + scriptName + "'"));
            log.warn((Object)buffer.toString());
            throw new SecurityException("Class not found");
        }
        if (creator.isHidden() && !includeHidden) {
            log.warn((Object)("Attempt made to get hidden class with name: " + scriptName + " while includeHidden=false"));
            throw new SecurityException("Class not found");
        }
        return creator;
    }

    @Override
    public void setCreators(Map<String, Creator> creators) {
        this.creators = creators;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isInitApplicationScopeCreatorsAtStartup() {
        return this.initApplicationScopeCreatorsAtStartup;
    }

    public void setInitApplicationScopeCreatorsAtStartup(boolean initApplicationScopeCreatorsAtStartup) {
        this.initApplicationScopeCreatorsAtStartup = initApplicationScopeCreatorsAtStartup;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

