/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ErrorOutboundVariable;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.RealRawData;
import org.directwebremoting.io.RawData;
import org.directwebremoting.util.ClasspathScanner;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverterManager
implements ConverterManager {
    protected Map<Property, Property> propertyOverrideMap = new HashMap<Property, Property>();
    protected Map<String, Class<? extends Converter>> converterTypes = new HashMap<String, Class<? extends Converter>>();
    protected Map<String, Converter> converters = new HashMap<String, Converter>();
    private static final List<String> ignore = Arrays.asList("converter", "match");
    private static final Log log = LogFactory.getLog(DefaultConverterManager.class);

    @Override
    public void addConverterType(String id, String className) {
        if (!LocalUtil.isJavaIdentifier(id)) {
            Loggers.STARTUP.error((Object)("Illegal identifier: '" + id + "'"));
            return;
        }
        Class<Converter> clazz = LocalUtil.classForName(id, className, Converter.class);
        if (clazz != null) {
            Loggers.STARTUP.debug((Object)("- adding converter type: " + id + " = " + clazz.getName()));
            this.converterTypes.put(id, clazz);
        }
    }

    @Override
    public void addConverter(String match, String type, Map<String, String> params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class<? extends Converter> clazz = this.converterTypes.get(type);
        if (clazz == null) {
            log.info((Object)("Probably not an issue: " + match + " is not available so the " + type + " converter will not load. This is only an problem if you wanted to use it."));
            return;
        }
        Converter converter = clazz.newInstance();
        LocalUtil.setParams(converter, params, ignore);
        this.addConverter(match, converter);
    }

    @Override
    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        if (LocalUtil.hasText(match) && match.contains("*") && !match.startsWith("[")) {
            boolean recursive = match.endsWith("**");
            String scan = recursive ? match.substring(0, match.length() - 1) : match;
            ClasspathScanner scanner = new ClasspathScanner(scan, recursive);
            for (String clazz : scanner.getClasses()) {
                this.addConverter(clazz, converter);
            }
        } else {
            block9: {
                Converter other = this.converters.get(match);
                if (other != null) {
                    Loggers.STARTUP.warn((Object)("Clash of converters for " + match + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName()));
                }
                Loggers.STARTUP.debug((Object)("- adding converter: " + converter.getClass().getSimpleName() + " for " + match));
                converter.setConverterManager(this);
                if (converter instanceof NamedConverter) {
                    try {
                        NamedConverter namedConverter = (NamedConverter)converter;
                        if (!LocalUtil.hasLength(namedConverter.getJavascript())) break block9;
                        Class<?> javaClass = Class.forName(match);
                        namedConverter.setJavascript(this.inferClassName(match, namedConverter.getJavascript()));
                        namedConverter.setInstanceType(javaClass);
                        if (LocalUtil.hasLength(namedConverter.getJavascriptSuperClass())) break block9;
                        for (Class<?> javaSuperClass = javaClass.getSuperclass(); javaSuperClass != null; javaSuperClass = javaSuperClass.getSuperclass()) {
                            String jsSuperClassName = this.getMappedJavaScriptClassName(javaSuperClass);
                            if (jsSuperClassName == null) continue;
                            namedConverter.setJavascriptSuperClass(jsSuperClassName);
                            break;
                        }
                        if (LocalUtil.hasLength(namedConverter.getJavascriptSuperClass())) break block9;
                        for (Class<?> checkInterfacesOnClass = javaClass; checkInterfacesOnClass != null; checkInterfacesOnClass = checkInterfacesOnClass.getSuperclass()) {
                            String jsSuperClassName = this.findMappedJavaScriptClassNameForAnyInterface(checkInterfacesOnClass);
                            if (jsSuperClassName == null) continue;
                            namedConverter.setJavascriptSuperClass(jsSuperClassName);
                            break;
                        }
                    }
                    catch (Exception cne) {
                        Loggers.STARTUP.warn((Object)("Could not load class [" + match + "]. Conversion will try to work upon other runtime information"));
                    }
                }
            }
            this.converters.put(match, converter);
        }
    }

    protected String inferClassName(String match, String jsClassName) {
        String className = jsClassName;
        if (jsClassName != null) {
            if ("*".equals(jsClassName)) {
                className = match.substring(match.lastIndexOf(46) + 1);
            } else if ("**".equals(jsClassName)) {
                className = match;
            } else if (jsClassName.indexOf("*") > 0) {
                className = jsClassName.replace("*", match.substring(match.lastIndexOf(46) + 1));
            }
            if (!className.equals(jsClassName) && log.isDebugEnabled()) {
                Loggers.STARTUP.debug((Object)("- expanded javascript [" + jsClassName + "] to [" + className + "] for " + match));
            }
        }
        return className;
    }

    protected String getMappedJavaScriptClassName(Class<?> javaClass) {
        NamedConverter namedConv;
        Converter conv = this.converters.get(javaClass.getName());
        if (conv != null && conv instanceof NamedConverter && LocalUtil.hasLength((namedConv = (NamedConverter)conv).getJavascript())) {
            return namedConv.getJavascript();
        }
        return null;
    }

    protected String findMappedJavaScriptClassNameForAnyInterface(Class<?> checkInterfacesOnClass) {
        Class<?>[] interfaces;
        for (Class<?> intfc : interfaces = checkInterfacesOnClass.getInterfaces()) {
            String jsClassName = this.getMappedJavaScriptClassName(intfc);
            if (jsClassName != null) {
                return jsClassName;
            }
            jsClassName = this.findMappedJavaScriptClassNameForAnyInterface(intfc);
            if (jsClassName == null) continue;
            return jsClassName;
        }
        return null;
    }

    @Override
    public Collection<String> getConverterMatchStrings() {
        return Collections.unmodifiableSet(this.converters.keySet());
    }

    @Override
    public Converter getConverterByMatchString(String match) {
        return this.converters.get(match);
    }

    @Override
    public boolean isConvertable(Class<?> paramType) {
        return this.getConverter(paramType) != null;
    }

    @Override
    public Class<?> getClientDeclaredType(InboundVariable data) {
        if (data == null) {
            return null;
        }
        String objectName = data.getNamedObjectType();
        if (objectName != null) {
            NamedConverter converter = this.getNamedConverter(Object.class, objectName);
            if (converter != null) {
                return converter.getInstanceType();
            }
            return null;
        }
        return null;
    }

    @Override
    public <T> T convertInbound(Class<T> paramType, InboundVariable data, Property thc) throws ConversionException {
        InboundContext context = data.getContext();
        Object converted = context.getConverted(data, paramType);
        if (converted == null) {
            Converter converter = null;
            String type = data.getNamedObjectType();
            if (type != null) {
                converter = this.getNamedConverter(paramType, type);
            }
            if (converter == null) {
                converter = this.getConverter(paramType);
            }
            if (converter == null) {
                log.error((Object)("Missing converter. Context of conversion: " + thc));
                throw new ConversionException(paramType, "No converter found inbound for '" + paramType.getName() + "'");
            }
            context.pushContext(thc);
            converted = converter.convertInbound(paramType, data);
            context.popContext();
        }
        return (T)converted;
    }

    @Override
    public <T> T convertInbound(Class<T> paramType, RawData rawData) throws ConversionException {
        RealRawData realRawData = (RealRawData)rawData;
        InboundVariable inboundVariable = realRawData.getInboundVariable();
        return this.convertInbound(paramType, inboundVariable, null);
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext converted) throws ConversionException {
        if (data == null) {
            return new NonNestedOutboundVariable("null");
        }
        OutboundVariable ov = converted.get(data);
        if (ov != null) {
            return ov.getReferenceVariable();
        }
        Converter converter = this.getConverter(data);
        if (converter == null) {
            String message = "No converter found for '" + data.getClass().getName() + "'";
            log.error((Object)message);
            return new ErrorOutboundVariable(message);
        }
        return converter.convertOutbound(data, converted);
    }

    @Override
    public void setOverrideProperty(Property original, Property replacement) {
        this.propertyOverrideMap.put(original, replacement);
    }

    @Override
    public Property checkOverride(Property property) {
        Property override = this.propertyOverrideMap.get(property);
        if (override != null) {
            return override;
        }
        return property;
    }

    @Override
    public void setConverters(Map<String, Converter> converters) {
        this.converters = converters;
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    protected NamedConverter getNamedConverter(Class<?> paramType, String javascriptClassName) throws ConversionException {
        for (Map.Entry<String, Converter> entry : this.converters.entrySet()) {
            NamedConverter boConv;
            String match = entry.getKey();
            Converter conv = entry.getValue();
            if (!(conv instanceof NamedConverter) || (boConv = (NamedConverter)conv).getJavascript() == null || !boConv.getJavascript().equals(javascriptClassName)) continue;
            try {
                Class<?> inboundClass = LocalUtil.classForName(match);
                if (!paramType.isAssignableFrom(inboundClass)) continue;
                boConv.setInstanceType(inboundClass);
                return boConv;
            }
            catch (ClassNotFoundException ex) {
                throw new ConversionException(paramType, (Throwable)ex);
            }
        }
        return null;
    }

    private Converter getConverter(Class<?> paramType) {
        block7: {
            Converter converter = this.getConverterAssignableFrom(paramType);
            if (converter != null) {
                return converter;
            }
            String lookup = paramType.getName();
            if (lookup.startsWith("$Proxy") && (converter = this.converters.get("$Proxy*")) != null) {
                return converter;
            }
            while (true) {
                if ((converter = this.converters.get(lookup + ".*")) != null) {
                    return converter;
                }
                converter = this.converters.get(lookup + '*');
                if (converter != null) {
                    return converter;
                }
                if (lookup.length() == 0) break block7;
                int lastdot = lookup.lastIndexOf(46);
                if (lastdot != -1) {
                    lookup = lookup.substring(0, lastdot);
                    continue;
                }
                int arrayMarkers = 0;
                while (lookup.charAt(arrayMarkers) == '[') {
                    ++arrayMarkers;
                }
                if (arrayMarkers == 0) break block7;
                converter = this.converters.get(lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1));
                if (converter != null) break;
            }
            return converter;
        }
        return null;
    }

    private Converter getConverterAssignableFrom(Class<?> paramType) {
        if (paramType == null) {
            return null;
        }
        String lookup = paramType.getName();
        Converter converter = this.converters.get(lookup);
        if (converter != null) {
            return converter;
        }
        for (Class<?> anInterface : paramType.getInterfaces()) {
            converter = this.getConverterAssignableFrom(anInterface);
            if (converter == null) continue;
            this.converters.put(lookup, converter);
            return converter;
        }
        converter = this.getConverterAssignableFrom(paramType.getSuperclass());
        if (converter != null) {
            this.converters.put(lookup, converter);
        }
        return converter;
    }
}

