/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainer
implements Container {
    private static final Log log = LogFactory.getLog(AbstractContainer.class);

    protected void callInitializingBeans() {
        this.callInitializingBeans(this.getBeanNames());
    }

    protected void callInitializingBeans(Collection<String> beanNames) {
        for (String name : beanNames) {
            Object bean = this.getBean(name);
            if (!(bean instanceof InitializingBean)) continue;
            InitializingBean startMeUp = (InitializingBean)bean;
            startMeUp.afterContainerSetup(this);
        }
    }

    @Override
    public <T> T getBean(Class<T> type) {
        Object bean = this.getBean(type.getName());
        try {
            return type.cast(bean);
        }
        catch (ClassCastException ex) {
            log.error((Object)("ClassCastException: Asked for implementation of " + type.getName() + " but the container has a type " + bean.getClass().getName()));
            log.error((Object)("  - calling toString() on returned bean gives: " + bean));
            throw ex;
        }
    }
}

