/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import org.directwebremoting.ConversionException;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.extend.Property;
import org.directwebremoting.hibernate.H2PropertyDescriptorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2BeanConverter
extends BeanConverter {
    protected final Map<String, Method> methods = new HashMap<String, Method>();

    @Override
    public Map<String, Property> getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws ConversionException {
        Class clazz = Hibernate.getClass((Object)example);
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                String name = descriptor.getName();
                if ("class".equals(name) || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                properties.put(name, new H2PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (Exception ex) {
            throw new ConversionException(clazz, (Throwable)ex);
        }
    }

    protected Method findGetter(Object data, String property) throws IntrospectionException {
        String key = data.getClass().getName() + ":" + property;
        Method method = this.methods.get(key);
        if (method == null) {
            PropertyDescriptor[] props;
            for (PropertyDescriptor prop : props = Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors()) {
                if (!prop.getName().equalsIgnoreCase(property)) continue;
                method = prop.getReadMethod();
            }
            this.methods.put(key, method);
        }
        return method;
    }
}

