/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.InjectedConfig;
import org.directwebremoting.guice.InternalAjaxFilterManager;
import org.directwebremoting.guice.InternalConverterManager;
import org.directwebremoting.guice.InternalCreatorManager;
import org.directwebremoting.guice.util.ContextCloseHandlers;
import org.directwebremoting.servlet.DwrServlet;
import org.directwebremoting.util.FakeServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrGuiceServlet
extends DwrServlet {
    private volatile ServletContext servletContext;
    private static final String INIT_CREATOR_MANAGER = CreatorManager.class.getName();
    private static final String INIT_CONVERTER_MANAGER = ConverterManager.class.getName();
    private static final String INIT_AJAX_FILTER_MANAGER = AjaxFilterManager.class.getName();
    private static final Log log = LogFactory.getLog(DwrGuiceServlet.class);

    @Override
    public void init(final ServletConfig servletConfig) throws ServletException {
        this.servletContext = servletConfig.getServletContext();
        try {
            DwrGuiceUtil.withServletContext(this.servletContext, new Callable<Void>(){

                @Override
                public Void call() throws ServletException {
                    FakeServletConfig config = new FakeServletConfig(servletConfig);
                    DwrGuiceServlet.this.setInitParameters(config);
                    DwrGuiceServlet.this.configureDelegatedTypes(config);
                    DwrGuiceServlet.super.init(config);
                    DwrGuiceServlet.initApplicationScoped();
                    return null;
                }
            });
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError((Object)("unexpected exception: " + e));
        }
    }

    @Override
    public void destroy() {
        ServletContext localContext = this.servletContext;
        this.servletContext = null;
        DwrGuiceUtil.withServletContext(localContext, new Runnable(){

            public void run() {
                List exceptions = DwrGuiceServlet.destroyApplicationScoped();
                DwrGuiceServlet.super.destroy();
                for (Exception ex : exceptions) {
                    log.warn((Object)"During servlet shutdown", (Throwable)ex);
                }
            }
        });
    }

    private void setInitParameters(FakeServletConfig config) {
        InjectedConfig cfg = new InjectedConfig(config);
        DwrGuiceUtil.getInjector().injectMembers((Object)cfg);
        cfg.setParameters();
    }

    private void configureDelegatedTypes(FakeServletConfig config) {
        InternalCreatorManager.setTypeName(config.getInitParameter(INIT_CREATOR_MANAGER));
        InternalConverterManager.setTypeName(config.getInitParameter(INIT_CONVERTER_MANAGER));
        InternalAjaxFilterManager.setTypeName(config.getInitParameter(INIT_AJAX_FILTER_MANAGER));
        config.setInitParameter(INIT_CREATOR_MANAGER, InternalCreatorManager.class.getName());
        config.setInitParameter(INIT_CONVERTER_MANAGER, InternalConverterManager.class.getName());
        config.setInitParameter(INIT_AJAX_FILTER_MANAGER, InternalAjaxFilterManager.class.getName());
    }

    private static void initApplicationScoped() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key<?> key : DwrScopes.APPLICATION.getKeysInScope()) {
            injector.getInstance(key);
        }
    }

    private static List<Exception> destroyApplicationScoped() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        DwrScopes.APPLICATION.closeAll(ContextCloseHandlers.newExceptionLoggingCloseableHandler(exceptions));
        return exceptions;
    }
}

