/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.filter;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.filter.LogAjaxFilter;

public class AuditLogAjaxFilter
implements AjaxFilter,
LogAjaxFilter {
    private static final List<Class<?>> toStringClasses = new ArrayList();
    private static int maxStringLength;
    private static final Log log;

    public Object doFilter(Object obj, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        StringBuilder call = new StringBuilder();
        call.append(obj.getClass().getSimpleName());
        call.append('.');
        call.append(method.getName());
        call.append('(');
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                call.append(", ");
            }
            call.append(this.toString(params[i]));
        }
        call.append(')');
        try {
            Object reply = chain.doFilter(obj, method, params);
            log.info((Object)(call.toString() + " = " + this.toString(reply)));
            return reply;
        }
        catch (InvocationTargetException ex) {
            log.info((Object)(call.toString() + " = " + ex.getTargetException()), ex.getTargetException());
            throw ex;
        }
        catch (Exception ex) {
            log.info((Object)(call.toString() + " = " + ex), (Throwable)ex);
            throw ex;
        }
        catch (Error ex) {
            log.warn((Object)(call.toString() + " = " + ex), (Throwable)ex);
            throw ex;
        }
    }

    private String toString(Object reply) {
        if (reply == null) {
            return "null";
        }
        if (reply.getClass().isArray()) {
            if (reply.getClass().getComponentType().isPrimitive()) {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                for (int i = 0; i < Array.getLength(reply); ++i) {
                    if (i != 0) {
                        builder.append(",");
                    }
                    builder.append(Array.get(reply, i));
                }
                builder.append("]");
                reply = builder.toString();
            } else {
                reply = Arrays.deepToString((Object[])reply);
            }
        }
        if (reply instanceof String) {
            return this.shorten((String)reply, maxStringLength);
        }
        if (toStringClasses.contains(reply.getClass())) {
            return reply.toString();
        }
        return this.shorten(reply.toString(), maxStringLength);
    }

    private String shorten(String str, int length) {
        if (str.length() > length) {
            return '\"' + str.substring(0, length - 3) + "...\"";
        }
        return '\"' + str + '\"';
    }

    static {
        toStringClasses.add(Boolean.TYPE);
        toStringClasses.add(Character.TYPE);
        toStringClasses.add(Byte.TYPE);
        toStringClasses.add(Short.TYPE);
        toStringClasses.add(Integer.TYPE);
        toStringClasses.add(Long.TYPE);
        toStringClasses.add(Float.TYPE);
        toStringClasses.add(Double.TYPE);
        toStringClasses.add(Void.TYPE);
        toStringClasses.add(Boolean.class);
        toStringClasses.add(Character.class);
        toStringClasses.add(Byte.class);
        toStringClasses.add(Short.class);
        toStringClasses.add(Integer.class);
        toStringClasses.add(Long.class);
        toStringClasses.add(Float.class);
        toStringClasses.add(Double.class);
        toStringClasses.add(Void.class);
        maxStringLength = 40;
        log = LogFactory.getLog(AuditLogAjaxFilter.class);
    }
}

