/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.filter;

import java.lang.reflect.Method;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.io.DwrConvertedException;

public class ActionTimeoutAjaxFilter
implements AjaxFilter {
    private long actionTimeoutMillis;
    private String onTimeout = "window.setLocation('about:blank');";
    private static final String ATTRIBUTE_LAST_ACTION = "org.directwebremoting.filter.ActionTimeoutAjaxFilter.lastActionTime";

    public Object doFilter(Object obj, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        long now;
        ScriptSession session = WebContextFactory.get().getScriptSession();
        Long lastAccess = (Long)session.getAttribute(ATTRIBUTE_LAST_ACTION);
        if (lastAccess != null && (now = System.currentTimeMillis()) > lastAccess + this.actionTimeoutMillis) {
            session.addScript(new ScriptBuffer(this.onTimeout));
            session.invalidate();
            throw new DwrConvertedException("Your session has timed out");
        }
        Object reply = chain.doFilter(obj, method, params);
        session.setAttribute(ATTRIBUTE_LAST_ACTION, System.currentTimeMillis());
        return reply;
    }

    public void setActionTimeoutMillis(long actionTimeoutMillis) {
        this.actionTimeoutMillis = actionTimeoutMillis;
    }

    public void setOnTimeout(String onTimeout) {
        this.onTimeout = onTimeout;
    }
}

