/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.NestedProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptorProperty
implements Property {
    protected PropertyDescriptor descriptor;

    public PropertyDescriptorProperty(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        Method method = this.descriptor.getReadMethod();
        Type[] types = method.getGenericParameterTypes();
        if (types.length == 0) {
            return this.descriptor.getPropertyType();
        }
        Type parameterType = types[0];
        return LocalUtil.toClass(parameterType, this.toString());
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        try {
            return this.descriptor.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new ConversionException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        try {
            this.descriptor.getWriteMethod().invoke(bean, value);
        }
        catch (InvocationTargetException ex) {
            throw new ConversionException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public Property createChild(int newParameterNumber) {
        Method method = this.descriptor.getReadMethod();
        Type type = method.getGenericReturnType();
        if (type == null) {
            return new NestedProperty(this, method, null, 0, newParameterNumber);
        }
        return new NestedProperty(this, method, type, 0, newParameterNumber);
    }

    public int hashCode() {
        return this.descriptor.getReadMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescriptorProperty that = (PropertyDescriptorProperty)obj;
        return this.descriptor.getReadMethod().equals(that.descriptor.getReadMethod());
    }

    public String toString() {
        return "PropertyDescriptorProperty[" + this.descriptor.getName() + "=" + this.descriptor.getPropertyType() + "]";
    }
}

