/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.util.JavascriptUtil;

public class EnginePrivate {
    public static ScriptBuffer getRemoteHandleCallbackScript(String batchId, String callId, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleCallback", batchId, callId, data);
        return script;
    }

    public static ScriptBuffer getRemoteHandleExceptionScript(String batchId, String callId, Throwable ex) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleException", batchId, callId, ex);
        return script;
    }

    public static ScriptBuffer getRemoteHandleNewScriptSessionScript(String newSessionId) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleNewScriptSession", newSessionId);
        return script;
    }

    public static ScriptBuffer getRemoteHandleNewWindowNameScript(String windowName) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleNewWindowName", windowName);
        return script;
    }

    public static String getRemoteHandleBatchExceptionScript(String batchId, Exception ex) {
        StringBuffer reply = new StringBuffer();
        String output = JavascriptUtil.escapeJavaScript(ex.getMessage());
        String params = "{ name:'" + ex.getClass().getName() + "', message:'" + output + "' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine.remote.handleBatchException(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine.remote.handleBatchException(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static ScriptBuffer getRemoteExecuteFunctionScript(String id, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleFunctionCall", id, params);
        return script;
    }

    public static ScriptBuffer getRemoteExecuteObjectScript(String id, String methodName, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleObjectCall", id, methodName, params);
        return script;
    }

    public static ScriptBuffer getRemoteSetObjectScript(String id, String propertyName, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleSetCall", id, propertyName, data);
        return script;
    }

    public static ScriptBuffer getRemoteCloseFunctionScript(String id) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleFunctionClose", id);
        return script;
    }

    public static String getRemotePollCometDisabledScript(String batchId) {
        StringBuffer reply = new StringBuffer();
        String params = "{ name:'dwr.engine.pollAndCometDisabled', message:'Polling and Comet are disabled. See the server logs.' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine.remote.pollCometDisabled(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine.remote.pollCometDisabled(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String xmlStringToJavascriptDomElement(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine.serialize.toDomElement(\"" + xmlout + "\")";
    }

    public static String xmlStringToJavascriptDomDocument(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine.serialize.toDomDocument(\"" + xmlout + "\")";
    }

    public static String getEngineInitScript() {
        return "// Provide a default path to dwr.engine\nif (typeof this['dwr'] == 'undefined') this.dwr = {};\nif (typeof dwr['engine'] == 'undefined') dwr.engine = {};\nif (typeof dwr.engine['_mappedClasses'] == 'undefined') dwr.engine._mappedClasses = {};\n\n";
    }

    public static String getExecuteFunctionName() {
        return "dwr.engine._execute";
    }

    public static String remoteBeginIFrameResponse(String batchId, boolean useWindowParent) {
        String script = "dwr.engine.transport.iframe.remote.beginIFrameResponse(this.frameElement" + (batchId == null ? "" : ", '" + batchId + "'") + ");";
        if (useWindowParent) {
            script = EnginePrivate.addWindowParent(script);
        }
        return script;
    }

    public static String remoteEndIFrameResponse(String batchId, boolean useWindowParent) {
        String script = "dwr.engine.transport.iframe.remote.endIFrameResponse(" + (batchId == null ? "" : "'" + batchId + "'") + ");";
        if (useWindowParent) {
            script = EnginePrivate.addWindowParent(script);
        }
        return script;
    }

    public static String remoteEval(String script) {
        String script2 = "dwr.engine._eval(\"" + JavascriptUtil.escapeJavaScript(script) + "\");";
        return EnginePrivate.addWindowParent(script2);
    }

    public static ScriptBuffer createForeignWindowProxy(String windowName, ScriptBuffer original) {
        String proxy = JavascriptUtil.escapeJavaScript(original.toString());
        ScriptBuffer reply = new ScriptBuffer();
        reply.appendCall("dwr.engine.remote.handleForeign", windowName, proxy);
        reply.appendData(proxy);
        return reply;
    }

    private static String addWindowParent(String script) {
        return "try { window.parent." + script + " } catch(ex) { if (!(ex.number && ex.number == -2146823277)) { throw ex; }}";
    }
}

