/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;

public class ContainerUtil {
    private static final Log log = LogFactory.getLog(ContainerUtil.class);

    public static boolean getBooleanSetting(Container container, String name, boolean defaultValue) {
        Object value = container.getBean(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public static int getIntSetting(Container container, String name, int defaultValue) {
        Object value = container.getBean(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            log.warn((Object)("Failed to convert value '" + value + "' from setting '" + name + "' to an integer: " + ex.getMessage()));
            return defaultValue;
        }
    }
}

