/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.CommonsFileUpload;
import org.directwebremoting.dwrp.FileUpload;
import org.directwebremoting.dwrp.UnsupportedFileUpload;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch {
    private final boolean get;
    private final String scriptSessionId;
    private final String httpSessionId;
    private final String page;
    private final String windowName;
    private final Map<String, FormField> extraParameters;
    private static final FileUpload UPLOADER;
    private static final Log log;

    public Batch(HttpServletRequest request) throws ServerException {
        this.get = "GET".equals(request.getMethod());
        this.extraParameters = this.get ? this.parseGet(request) : this.parsePost(request);
        this.scriptSessionId = this.extractParameter("scriptSessionId");
        this.httpSessionId = this.extractParameter("httpSessionId");
        this.page = LocalUtil.urlDecode(this.extractParameter("page"));
        this.windowName = this.extractParameter("windowName");
    }

    public Batch(Map<String, FormField> allParameters, boolean get) {
        this.extraParameters = allParameters;
        this.get = get;
        this.scriptSessionId = this.extractParameter("scriptSessionId");
        this.httpSessionId = this.extractParameter("httpSessionId");
        this.page = this.extractParameter("page");
        this.windowName = this.extractParameter("windowName");
    }

    protected String extractParameter(String paramName) {
        FormField formField = this.extraParameters.remove(paramName);
        if (formField == null) {
            throw new IllegalArgumentException("Failed to find parameter: " + paramName);
        }
        return formField.getString();
    }

    private Map<String, FormField> parsePost(HttpServletRequest req) throws ServerException {
        Map<String, FormField> paramMap = Batch.isMultipartContent(req) ? UPLOADER.parseRequest(req) : this.parseBasicPost(req);
        if (paramMap.size() == 1) {
            Batch.parseBrokenMacPost(paramMap);
        }
        return paramMap;
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    private Map<String, FormField> parseBasicPost(HttpServletRequest req) throws ServerException {
        HashMap<String, FormField> paramMap = new HashMap<String, FormField>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
            block9: while (true) {
                String line;
                if ((line = in.readLine()) == null) {
                    if (paramMap.isEmpty()) {
                        Enumeration en = req.getParameterNames();
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            paramMap.put(name, new FormField(req.getParameter(name)));
                        }
                    }
                    break;
                }
                if (line.indexOf(38) != -1) {
                    log.debug((Object)"Using iframe POST mode");
                    StringTokenizer st = new StringTokenizer(line, "&");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block9;
                        String part = st.nextToken();
                        part = LocalUtil.urlDecode(part);
                        Batch.parsePostLine(part, paramMap);
                    }
                }
                Batch.parsePostLine(line, paramMap);
            }
        }
        catch (Exception ex) {
            throw new ServerException("Failed to read input", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
        return paramMap;
    }

    private static void parseBrokenMacPost(Map<String, FormField> paramMap) {
        log.debug((Object)"Using Broken Safari POST mode");
        Iterator<String> it = paramMap.keySet().iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("No entries in non empty map!");
        }
        String key = it.next();
        String value = paramMap.get(key).getString();
        String line = key + "=" + value;
        StringTokenizer st = new StringTokenizer(line, "\n");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            part = LocalUtil.urlDecode(part);
            Batch.parsePostLine(part, paramMap);
        }
    }

    private static void parsePostLine(String line, Map<String, FormField> paramMap) {
        if (line.length() == 0) {
            return;
        }
        int sep = line.indexOf("=");
        if (sep == -1) {
            paramMap.put(line, null);
        } else {
            String key = line.substring(0, sep);
            String value = line.substring(sep + "=".length());
            paramMap.put(key, new FormField(value));
        }
    }

    private Map<String, FormField> parseGet(HttpServletRequest req) throws ServerException {
        HashMap<String, FormField> convertedMap = new HashMap<String, FormField>();
        Map paramMap = req.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] array = (String[])entry.getValue();
            if (array.length == 1) {
                convertedMap.put(key, new FormField(array[0]));
                continue;
            }
            log.error((Object)("Multiple values for key: " + key));
            throw new ServerException("Multiple values for key. See console for more information");
        }
        return convertedMap;
    }

    public boolean isGet() {
        return this.get;
    }

    public String getScriptSessionId() {
        return this.scriptSessionId;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public String getPage() {
        return this.page;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public Map<String, FormField> getExtraParameters() {
        return this.extraParameters;
    }

    static {
        FileUpload test;
        log = LogFactory.getLog(Batch.class);
        try {
            test = new CommonsFileUpload();
            log.debug((Object)"Using commons-file-upload.");
        }
        catch (NoClassDefFoundError ex) {
            test = new UnsupportedFileUpload();
            log.debug((Object)"Failed to find commons-file-upload. File upload is not supported.");
        }
        catch (Exception ex) {
            test = new UnsupportedFileUpload();
            log.debug((Object)"Failed to start commons-file-upload. File upload is not supported.");
        }
        UPLOADER = test;
    }
}

