/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseDwrpHandler;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.dwrp.Html4kScriptConduit;
import org.directwebremoting.dwrp.HtmlScriptConduit;
import org.directwebremoting.dwrp.PartialResponse;
import org.directwebremoting.dwrp.PlainScriptConduit;
import org.directwebremoting.dwrp.PollBatch;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.OutputAlarm;
import org.directwebremoting.impl.PollingServerLoadMonitor;
import org.directwebremoting.impl.ShutdownAlarm;
import org.directwebremoting.impl.TimedAlarm;
import org.directwebremoting.util.BrowserDetect;

public class BasePollHandler
extends BaseDwrpHandler {
    protected boolean jsonOutput = false;
    protected boolean activeReverseAjaxEnabled = false;
    protected int maxWaitAfterWrite = -1;
    protected PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ServerLoadMonitor pollingServerLoadMonitor = new PollingServerLoadMonitor();
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    protected ContainerAbstraction containerAbstraction = null;
    protected ScheduledThreadPoolExecutor executor;
    protected boolean plain;
    private static final Log log = LogFactory.getLog(BasePollHandler.class);

    public BasePollHandler(boolean plain) {
        this.plain = plain;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean comet;
        PollBatch batch;
        if (this.containerAbstraction.isResponseCompleted(request)) {
            return;
        }
        try {
            batch = new PollBatch(request);
        }
        catch (Exception ex) {
            log.debug((Object)"Failed to parse request", (Throwable)ex);
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(null, ex);
            this.sendErrorScript(response, script);
            return;
        }
        this.checkGetAllowed(batch);
        this.checkNotCsrfAttack(request, batch);
        String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
        RealWebContext webContext = (RealWebContext)WebContextFactory.get();
        webContext.checkPageInformation(normalizedPage, batch.getScriptSessionId(), batch.getWindowName());
        if (!this.activeReverseAjaxEnabled) {
            log.error((Object)"Polling and Comet are disabled. To enable them set the init-param activeReverseAjaxEnabled to true. See http://getahead.org/dwr/server/servlet for more.");
            String script = EnginePrivate.getRemotePollCometDisabledScript(batch.getBatchId());
            this.sendErrorScript(response, script);
            return;
        }
        final RealScriptSession scriptSession = (RealScriptSession)webContext.getScriptSession();
        Sleeper sleeper = this.containerAbstraction.createSleeper(request);
        final BaseScriptConduit conduit = this.createScriptConduit(sleeper, batch, response);
        final ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        alarms.add(conduit);
        if (batch.getPartialResponse() == PartialResponse.NO || this.maxWaitAfterWrite != -1) {
            alarms.add(new OutputAlarm(sleeper, scriptSession, this.maxWaitAfterWrite, this.executor));
        }
        if (comet = BrowserDetect.supportsComet(request)) {
            String httpSessionId = webContext.getSession(true).getId();
            Collection<RealScriptSession> sessions = this.scriptSessionManager.getScriptSessionsByHttpSessionId(httpSessionId);
            int persistentConnections = 0;
            for (RealScriptSession session : sessions) {
                persistentConnections += session.countPersistentConnections();
            }
            int connectionLimit = BrowserDetect.getConnectionLimit(request);
            if (persistentConnections + 1 >= connectionLimit) {
                comet = false;
                if (log.isDebugEnabled()) {
                    String uaStr = BrowserDetect.getUserAgentDebugString(request);
                    log.debug((Object)("Persistent connections=" + persistentConnections + ". (limit=" + connectionLimit + " in " + uaStr + "). Polling"));
                }
            }
        } else {
            log.debug((Object)"Browser does not support comet, polling");
        }
        ServerLoadMonitor slm = comet ? this.serverLoadMonitor : this.pollingServerLoadMonitor;
        long connectedTime = slm.getConnectedTime();
        final int disconnectedTime = slm.getDisconnectedTime();
        alarms.add(new TimedAlarm(sleeper, connectedTime, this.executor));
        alarms.add(new ShutdownAlarm(sleeper, this.serverLoadMonitor));
        scriptSession.addScriptConduit(conduit);
        Runnable onAwakening = new Runnable(){

            public void run() {
                for (Alarm alarm : alarms) {
                    alarm.cancel();
                }
                scriptSession.removeScriptConduit(conduit);
                try {
                    conduit.close(disconnectedTime);
                }
                catch (IOException ex) {
                    log.warn((Object)"Failed to write reconnect info to browser");
                }
            }
        };
        sleeper.goToSleep(onAwakening);
    }

    private BaseScriptConduit createScriptConduit(Sleeper sleeper, PollBatch batch, HttpServletResponse response) throws IOException {
        BaseScriptConduit conduit = this.plain ? new PlainScriptConduit(sleeper, response, batch.getBatchId(), this.converterManager, this.jsonOutput) : (batch.getPartialResponse() == PartialResponse.FLUSH ? new Html4kScriptConduit(sleeper, response, batch.getBatchId(), this.converterManager, this.jsonOutput) : new HtmlScriptConduit(sleeper, response, batch.getBatchId(), this.converterManager, this.jsonOutput));
        return conduit;
    }

    protected void sendErrorScript(HttpServletResponse response, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        out.println("//#DWR-START#");
        out.println(script);
        out.println("//#DWR-END#");
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    @Deprecated
    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.activeReverseAjaxEnabled = pollAndCometEnabled;
    }

    public void setActiveReverseAjaxEnabled(boolean activeReverseAjaxEnabled) {
        this.activeReverseAjaxEnabled = activeReverseAjaxEnabled;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setContainerAbstraction(ContainerAbstraction containerAbstraction) {
        this.containerAbstraction = containerAbstraction;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

