/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.Handler;

public abstract class BaseDwrpHandler
implements Handler {
    private boolean crossDomainSessionSecurity = true;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private String sessionCookieName = "JSESSIONID";
    private static final Log log = LogFactory.getLog(BaseDwrpHandler.class);

    protected void checkGetAllowed(Batch batch) {
        if (!this.allowGetForSafariButMakeForgeryEasier && batch.isGet()) {
            log.error((Object)"GET is disallowed because it makes request forgery easier. See http://getahead.org/dwr/security/allowGetForSafariButMakeForgeryEasier for more details.");
            throw new SecurityException("GET Disallowed");
        }
    }

    protected void checkNotCsrfAttack(HttpServletRequest request, Batch batch) {
        String headerSessionId;
        if (!this.crossDomainSessionSecurity) {
            return;
        }
        if (request.isRequestedSessionIdValid() && request.isRequestedSessionIdFromCookie() && (headerSessionId = request.getRequestedSessionId()).length() > 0) {
            String bodySessionId = batch.getHttpSessionId();
            if (headerSessionId.equals(bodySessionId)) {
                return;
            }
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(this.sessionCookieName) || !cookie.getValue().equals(bodySessionId)) continue;
                return;
            }
            log.error((Object)"A request has been denied as a potential CSRF attack.");
            throw new SecurityException("CSRF Security Error");
        }
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }
}

