/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseDwrpHandler;
import org.directwebremoting.dwrp.CallBatch;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.SimpleInputStreamFactory;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.DebuggingPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCallHandler
extends BaseDwrpHandler {
    protected boolean debug = false;
    protected Remoter remoter = null;
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected PageNormalizer pageNormalizer = null;
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected static final String ATTRIBUTE_BATCH = "org.directwebremoting.dwrp.batch";
    private static final Log log = LogFactory.getLog(BaseCallHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            CallBatch batch = new CallBatch(request);
            this.checkGetAllowed(batch);
            this.checkNotCsrfAttack(request, batch);
            request.setAttribute(ATTRIBUTE_BATCH, (Object)batch);
            String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
            RealWebContext webContext = (RealWebContext)WebContextFactory.get();
            webContext.checkPageInformation(normalizedPage, batch.getScriptSessionId(), batch.getWindowName());
            this.storeParsedRequest(request, webContext, batch);
            Calls calls = this.marshallInbound(batch);
            Replies replies = this.remoter.execute(calls);
            this.marshallOutbound(replies, response);
        }
        catch (Exception ex) {
            this.marshallException(request, response, ex);
        }
    }

    public Calls marshallInbound(CallBatch batch) {
        Calls calls = batch.getCalls();
        for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            try {
                InboundContext inctx = batch.getInboundContexts().get(callNum);
                call.findMethod(this.creatorManager, this.converterManager, inctx, callNum);
                Method method = call.getMethod();
                if (method == null) {
                    log.warn((Object)("No methods to match " + call.getScriptName() + '.' + call.getMethodName()));
                    throw new IllegalArgumentException("Missing method or missing parameter converters");
                }
                inctx.dereference();
                int destParamCount = method.getParameterTypes().length;
                Object[] arguments = new Object[destParamCount];
                for (int j = 0; j < destParamCount; ++j) {
                    InboundVariable param = method.isVarArgs() && j + 1 == destParamCount ? inctx.createArrayWrapper(callNum, destParamCount) : inctx.getParameter(callNum, j);
                    ParameterProperty property = new ParameterProperty(method, j);
                    Class<?> paramType = method.getParameterTypes()[j];
                    try {
                        arguments[j] = this.converterManager.convertInbound(paramType, param, property);
                        continue;
                    }
                    catch (Exception ex) {
                        log.debug((Object)("Problem converting param=" + param + ", property=" + property + ", into paramType=" + paramType.getName() + ": " + ex));
                        throw ex;
                    }
                }
                call.setParameters(arguments);
                continue;
            }
            catch (Exception ex) {
                log.debug((Object)"Marshalling exception", (Throwable)ex);
                call.setMarshallFailure(ex);
            }
        }
        return calls;
    }

    private void storeParsedRequest(HttpServletRequest request, RealWebContext webContext, CallBatch batch) throws IOException {
        Map<String, FormField> paramMap = batch.getExtraParameters();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, FormField> entry : paramMap.entrySet()) {
                Object value;
                String key = entry.getKey();
                FormField formField = entry.getValue();
                if (formField == null) {
                    log.warn((Object)"Found a parameter with a null value. This is likely to be due to a URL with an & before the query parameters. Please URL encode such pages.");
                    throw new IllegalArgumentException("Empty input parameter. See logs for suggestions");
                }
                if (formField.isFile()) {
                    SimpleInputStreamFactory inFactory = new SimpleInputStreamFactory(formField.getInputStream());
                    value = new FileTransfer(formField.getName(), formField.getMimeType(), formField.getFileSize(), inFactory);
                } else {
                    value = formField.getString();
                }
                if (key.startsWith("p-")) {
                    request.setAttribute(key.substring("p-".length()), value);
                    log.debug((Object)("Moved param to request: " + key + "=" + value));
                    continue;
                }
                log.debug((Object)("Ignoring parameter: " + key + "=" + value));
            }
        }
    }

    public void marshallOutbound(Replies replies, HttpServletResponse response) throws IOException {
        RealScriptSession scriptSession;
        try {
            scriptSession = (RealScriptSession)WebContextFactory.get().getScriptSession();
        }
        catch (SecurityException ex) {
            return;
        }
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = this.debugScriptOutput && log.isDebugEnabled() ? new DebuggingPrintWriter("", response.getWriter()) : response.getWriter();
        CallScriptConduit conduit = new CallScriptConduit(out);
        if (out instanceof DebuggingPrintWriter) {
            DebuggingPrintWriter dpw = (DebuggingPrintWriter)out;
            dpw.setPrefix("out(" + conduit.hashCode() + "): ");
        }
        this.sendOutboundScriptPrefix(out, replies.getCalls().getBatchId());
        out.println("//#DWR-INSERT");
        scriptSession.writeScripts(conduit);
        out.println("//#DWR-REPLY");
        String batchId = replies.getCalls().getBatchId();
        for (int i = 0; i < replies.getReplyCount(); ++i) {
            ScriptBuffer script;
            Reply reply = replies.getReply(i);
            String callId = reply.getCallId();
            try {
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    script = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                    ((ScriptConduit)conduit).addScript(script);
                    continue;
                }
                Object data = reply.getReply();
                script = EnginePrivate.getRemoteHandleCallbackScript(batchId, callId, data);
                ((ScriptConduit)conduit).addScript(script);
                continue;
            }
            catch (IOException ex) {
                log.error((Object)("--Output Error: batchId[" + batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
                continue;
            }
            catch (ConversionException ex) {
                script = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(conduit, script);
                continue;
            }
            catch (Exception ex) {
                script = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(conduit, script);
                log.error((Object)("--ConversionException: batchId=" + batchId + " message=" + ex.toString()));
            }
        }
        this.sendOutboundScriptSuffix(out, replies.getCalls().getBatchId());
    }

    public void marshallException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = response.getWriter();
        CallBatch batch = (CallBatch)request.getAttribute(ATTRIBUTE_BATCH);
        String batchId = batch != null && batch.getCalls() != null ? batch.getCalls().getBatchId() : null;
        if (this.debug) {
            log.warn((Object)"Exception while processing batch", (Throwable)ex);
        }
        this.sendOutboundScriptPrefix(out, batchId);
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        out.print(script);
        this.sendOutboundScriptSuffix(out, batchId);
    }

    public void addScriptHandleExceptions(ScriptConduit conduit, ScriptBuffer script) throws IOException {
        try {
            conduit.addScript(script);
        }
        catch (ConversionException ex) {
            log.warn((Object)"Error marshalling exception. Is the exception converter configured?");
        }
    }

    protected abstract void sendScript(PrintWriter var1, String var2) throws IOException;

    protected abstract String getOutboundMimeType();

    protected abstract void sendOutboundScriptPrefix(PrintWriter var1, String var2) throws IOException;

    protected abstract void sendOutboundScriptSuffix(PrintWriter var1, String var2) throws IOException;

    public boolean isConvertable(Class<?> paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    protected class CallScriptConduit
    extends ScriptConduit {
        private final PrintWriter out;

        protected CallScriptConduit(PrintWriter out) {
            super(5, false);
            if (out == null) {
                throw new NullPointerException("out=null");
            }
            this.out = out;
        }

        public boolean addScript(ScriptBuffer script) throws IOException, ConversionException {
            BaseCallHandler.this.sendScript(this.out, ScriptBufferUtil.createOutput(script, BaseCallHandler.this.converterManager, BaseCallHandler.this.jsonOutput));
            return true;
        }
    }
}

