/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.datasync;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.datasync.AbstractStoreProvider;
import org.directwebremoting.datasync.ComparatorFactory;
import org.directwebremoting.datasync.DefaultComparatorFactory;
import org.directwebremoting.datasync.SortCriteriaComparator;
import org.directwebremoting.datasync.StoreProvider;
import org.directwebremoting.io.Item;
import org.directwebremoting.io.ItemUpdate;
import org.directwebremoting.io.MatchedItems;
import org.directwebremoting.io.SortCriterion;
import org.directwebremoting.io.StoreChangeListener;
import org.directwebremoting.io.StoreRegion;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapStoreProvider<T>
extends AbstractStoreProvider<T>
implements StoreProvider<T> {
    protected final ComparatorFactory<T> comparatorFactory;
    protected final StoreRegion baseRegion;
    protected final Map<StoreRegion, Index> data = new HashMap<StoreRegion, Index>();
    private static final Log log = LogFactory.getLog(MapStoreProvider.class);

    public MapStoreProvider(Map<String, T> datamap, Class<T> type) {
        this(datamap, type, new ArrayList<SortCriterion>(), new DefaultComparatorFactory());
    }

    public MapStoreProvider(Map<String, T> datamap, Class<T> type, ComparatorFactory<T> comparatorFactory) {
        this(datamap, type, new ArrayList<SortCriterion>(), comparatorFactory);
    }

    public MapStoreProvider(Class<T> type) {
        this(new HashMap(), type, new ArrayList<SortCriterion>(), new DefaultComparatorFactory());
    }

    public MapStoreProvider(Map<String, T> map, Class<T> type, List<SortCriterion> defaultCriteria, ComparatorFactory<T> comparatorFactory) {
        super(type);
        this.baseRegion = new StoreRegion(0, -1, defaultCriteria, null);
        this.comparatorFactory = comparatorFactory;
        Index index = new Index(this.baseRegion, map);
        this.data.put(this.baseRegion, index);
    }

    @Override
    public synchronized MatchedItems viewRegion(StoreRegion region) {
        Index index = this.getIndex(region);
        return MapStoreProvider.selectMatchedItems(index.getSortedData(), region.getStart(), region.getCount());
    }

    @Override
    public synchronized MatchedItems viewRegion(StoreRegion region, StoreChangeListener<T> listener) {
        MatchedItems matchedItems = this.viewRegion(region);
        HashSet<String> itemIds = new HashSet<String>();
        for (Item item : matchedItems.getViewedMatches()) {
            itemIds.add(item.getItemId());
        }
        this.setWatchedSet(listener, itemIds);
        return matchedItems;
    }

    @Override
    public Item viewItem(String itemId, StoreChangeListener<T> listener) {
        Item item = this.viewItem(itemId);
        if (item != null) {
            this.addWatchedSet(listener, Arrays.asList(item.getItemId()));
        }
        return item;
    }

    @Override
    public synchronized void unsubscribe(StoreChangeListener<T> listener) {
        this.setWatchedSet(listener, null);
    }

    @Override
    public synchronized void put(String itemId, T value) {
        for (Index index : this.data.values()) {
            index.put(itemId, value, true);
        }
    }

    @Override
    public synchronized void update(List<ItemUpdate> changes) throws SecurityException {
        HashMap<String, ArrayList<ItemUpdate>> groupedChanges = new HashMap<String, ArrayList<ItemUpdate>>();
        for (ItemUpdate itemUpdate : changes) {
            ArrayList<ItemUpdate> itemChanges = (ArrayList<ItemUpdate>)groupedChanges.get(itemUpdate.getItemId());
            if (itemChanges == null) {
                itemChanges = new ArrayList<ItemUpdate>();
                groupedChanges.put(itemUpdate.getItemId(), itemChanges);
            }
            itemChanges.add(itemUpdate);
        }
        for (Map.Entry entry : groupedChanges.entrySet()) {
            T t = this.getObject((String)entry.getKey());
            HashSet<String> changedAttributes = new HashSet<String>();
            for (ItemUpdate itemUpdate : changes) {
                String attribute = itemUpdate.getAttribute();
                Class<?> convertTo = LocalUtil.getPropertyType(t.getClass(), attribute);
                Object value = this.convert(itemUpdate.getNewValue(), convertTo);
                try {
                    LocalUtil.setProperty(t, attribute, value);
                    changedAttributes.add(attribute);
                }
                catch (SecurityException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new SecurityException(ex);
                }
            }
            Item item = new Item((String)entry.getKey(), t);
            this.fireItemChanged(item, changedAttributes);
        }
    }

    @Override
    protected synchronized T getObject(String itemId) {
        return (T)this.data.get(this.baseRegion).index.get(itemId);
    }

    public synchronized Map<String, T> asMap() {
        final Index original = this.data.get(this.baseRegion);
        return new AbstractMap<String, T>(){

            @Override
            public T put(String itemId, T value) {
                Object old = MapStoreProvider.this.getObject(itemId);
                MapStoreProvider.this.put(itemId, value);
                return old;
            }

            @Override
            public T remove(Object itemId) {
                Object old = MapStoreProvider.this.getObject((String)itemId);
                MapStoreProvider.this.put((String)itemId, (Object)null);
                return old;
            }

            @Override
            public Set<Map.Entry<String, T>> entrySet() {
                return new AbstractSet<Map.Entry<String, T>>(){

                    @Override
                    public Iterator<Map.Entry<String, T>> iterator() {
                        return original.index.entrySet().iterator();
                    }

                    @Override
                    public int size() {
                        return original.sortedData.size();
                    }

                    @Override
                    public boolean add(Map.Entry<String, T> entry) {
                        Object t = MapStoreProvider.this.getObject(entry.getKey());
                        MapStoreProvider.this.put(entry.getKey(), entry.getValue());
                        return t != null;
                    }

                    @Override
                    public boolean remove(Object o) {
                        Map.Entry entry = (Map.Entry)o;
                        Object old = MapStoreProvider.this.getObject((String)entry.getKey());
                        MapStoreProvider.this.put((String)entry.getKey(), (Object)null);
                        return old != null;
                    }
                };
            }
        };
    }

    protected synchronized Index getIndex(StoreRegion region) {
        Index index;
        if (region == null) {
            region = this.baseRegion;
        }
        if (region.getSort() == null) {
            region = new StoreRegion(region.getStart(), region.getCount(), this.baseRegion.getSort(), region.getQuery());
        }
        if ((index = this.data.get(region)) == null) {
            Index original = this.data.get(this.baseRegion);
            index = new Index(region, original);
            this.data.put(region, index);
            log.debug((Object)("Creating new Index: " + index));
        } else {
            log.debug((Object)("Using existing Index: " + index));
        }
        return index;
    }

    public synchronized String toString() {
        Index original = this.data.get(this.baseRegion);
        return "MapStoreProvider[type=" + this.type.getSimpleName() + ",entries=" + original.index.size() + ",indexes=" + this.data.size() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Index {
        private final SortedSet<Pair<String, T>> sortedData;
        private final Map<String, T> index = new HashMap();
        private final List<SortCriterion> sort;
        private final Map<String, String> query;

        public Index(StoreRegion baseRegion, Map<String, T> map) {
            this.sort = baseRegion.getSort();
            this.query = baseRegion.getQuery();
            this.sortedData = this.createEmptySortedData();
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue(), false);
            }
        }

        public Index(StoreRegion region, Index original) {
            this.sort = region.getSort();
            this.query = region.getQuery();
            this.sortedData = this.createEmptySortedData();
            for (Pair pair : original.sortedData) {
                this.put(pair, false);
            }
        }

        private SortedSet<Pair<String, T>> createEmptySortedData() {
            SortCriteriaComparator criteriaComparator = new SortCriteriaComparator(this.sort, MapStoreProvider.this.comparatorFactory);
            AbstractStoreProvider.PairComparator pairComparator = new AbstractStoreProvider.PairComparator(criteriaComparator);
            return new TreeSet(pairComparator);
        }

        public SortedSet<Pair<String, T>> getSortedData() {
            return this.sortedData;
        }

        public void remove(String itemId) {
            Object t = this.index.remove(itemId);
            this.sortedData.remove(new Pair(itemId, t));
            MapStoreProvider.this.fireItemRemoved(itemId);
        }

        public void put(Pair<String, T> pair, boolean notify) {
            if (pair.right == null) {
                this.remove((String)pair.left);
                return;
            }
            if (this.isRelevant(pair.right)) {
                boolean existing = this.index.containsKey(pair.left);
                this.sortedData.add(pair);
                this.index.put((String)pair.left, (Object)pair.right);
                if (notify) {
                    if (existing) {
                        MapStoreProvider.this.fireItemChanged(new Item((String)pair.left, pair.right), null);
                    } else {
                        MapStoreProvider.this.fireItemAdded(new Item((String)pair.left, pair.right));
                    }
                }
            }
        }

        public void put(String itemId, T t, boolean notify) {
            if (t == null) {
                this.remove(itemId);
                return;
            }
            if (this.isRelevant(t)) {
                boolean existing = this.index.containsKey(itemId);
                this.sortedData.add(new Pair(itemId, t));
                this.index.put(itemId, t);
                if (notify) {
                    if (existing) {
                        MapStoreProvider.this.fireItemChanged(new Item(itemId, t), null);
                    } else {
                        MapStoreProvider.this.fireItemAdded(new Item(itemId, t));
                    }
                }
            }
        }

        private boolean isRelevant(T t) {
            return this.query == null || this.query.isEmpty() || AbstractStoreProvider.passesFilter(t, this.query);
        }

        public String toString() {
            return "Map.Index[sortedData.size=" + this.sortedData.size() + ",index.size=" + this.index.size() + ",sort=" + this.sort + ",query=" + this.query + "]";
        }
    }
}

