/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.ConversionException;
import org.directwebremoting.convert.BasicObjectConverter;
import org.directwebremoting.extend.FieldProperty;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectConverter
extends BasicObjectConverter {
    private boolean force = false;

    public void setForce(String force) {
        this.force = Boolean.valueOf(force);
    }

    @Override
    public Map<String, Property> getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws ConversionException {
        Class<?> clazz = example.getClass();
        return this.getPropertyMapFromClass(clazz, readRequired, writeRequired);
    }

    @Override
    public Map<String, Property> getPropertyMapFromClass(Class<?> type, boolean readRequired, boolean writeRequired) {
        HashMap<String, Property> allFields = new HashMap<String, Property>();
        while (type != Object.class) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                String name = field.getName();
                if ("class".equals(name) || !this.isAllowedByIncludeExcludeRules(name)) continue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!this.force) continue;
                    field.setAccessible(true);
                }
                allFields.put(name, new FieldProperty(field));
            }
            type = type.getSuperclass();
        }
        return allFields;
    }

    @Override
    protected Property createTypeHintContext(InboundContext inctx, Property property) {
        return inctx.getCurrentProperty();
    }
}

