/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = LocalUtil.urlDecode(data.getValue());
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            String script;
            StringWriter xml;
            Format outformat = Format.getRawFormat();
            outformat.setEncoding("UTF-8");
            if (data instanceof Document) {
                xml = new StringWriter();
                XMLOutputter writer = new XMLOutputter(outformat);
                writer.output((Document)data, (Writer)xml);
                xml.flush();
                script = EnginePrivate.xmlStringToJavascriptDomDocument(xml.toString());
            } else if (data instanceof Element) {
                xml = new StringWriter();
                XMLOutputter writer = new XMLOutputter(outformat);
                writer.output((Element)data, (Writer)xml);
                xml.flush();
                script = EnginePrivate.xmlStringToJavascriptDomElement(xml.toString());
            } else {
                throw new ConversionException(data.getClass());
            }
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
    }
}

