/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.ArrayOutboundVariable;
import org.directwebremoting.extend.ConvertUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ErrorOutboundVariable;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter
implements Converter {
    private static final Log log = LogFactory.getLog(ArrayConverter.class);
    private ConverterManager converterManager = null;

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        if (!paramType.isArray()) {
            throw new ConversionException(paramType);
        }
        Class<?> componentType = paramType.getComponentType();
        InboundContext incx = data.getContext();
        InboundVariable[] members = data.getMembers();
        if (members != null) {
            Object array = Array.newInstance(componentType, members.length);
            data.getContext().addConverted(data, paramType, array);
            for (int i = 0; i < members.length; ++i) {
                Object output = this.converterManager.convertInbound(componentType, members[i], data.getContext().getCurrentProperty());
                Array.set(array, i, output);
            }
            return array;
        }
        String value = data.getValue();
        if (!value.startsWith("[")) {
            log.error((Object)("Found array end without array start: " + data.getValue()));
            throw new IllegalArgumentException("Could not parse input. See logs for details.");
        }
        value = value.substring(1);
        if (!value.endsWith("]")) {
            log.error((Object)("Found array end without array end: " + data.getValue()));
            throw new IllegalArgumentException("Could not parse input. See logs for details.");
        }
        value = value.substring(0, value.length() - 1);
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        Object array = Array.newInstance(componentType, size);
        data.getContext().addConverted(data, paramType, array);
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            String[] split = ConvertUtil.splitInbound(token);
            String splitType = split[0];
            String splitValue = split[1];
            InboundVariable nested = new InboundVariable(incx, null, splitType, splitValue);
            nested.dereference();
            Object output = this.converterManager.convertInbound(componentType, nested, data.getContext().getCurrentProperty());
            Array.set(array, i, output);
        }
        return array;
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        if (!data.getClass().isArray()) {
            throw new ConversionException(data.getClass());
        }
        ArrayOutboundVariable ov = new ArrayOutboundVariable(outctx);
        outctx.put(data, ov);
        int size = Array.getLength(data);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        for (int i = 0; i < size; ++i) {
            OutboundVariable nested;
            try {
                nested = this.converterManager.convertOutbound(Array.get(data, i), outctx);
            }
            catch (Exception ex) {
                String errorMessage = "Conversion error for " + data.getClass().getName() + ".";
                log.warn((Object)errorMessage, (Throwable)ex);
                nested = new ErrorOutboundVariable(errorMessage);
            }
            ovs.add(nested);
        }
        ov.setChildren(ovs);
        return ov;
    }
}

