/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContext;

public class WebContextFactory {
    private static WebContextBuilder builder = null;
    private static final Log log = LogFactory.getLog(WebContextFactory.class);

    public static WebContext get() {
        if (builder == null) {
            log.warn((Object)"Missing WebContextBuilder. Is DWR setup properly?");
            return null;
        }
        return builder.get();
    }

    public static void attach(Container container) {
        builder = container.getBean(WebContextBuilder.class);
    }

    public static interface WebContextBuilder {
        public WebContext get();

        public void engageThread(Container var1, HttpServletRequest var2, HttpServletResponse var3);

        public void disengageThread();
    }
}

