/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting;

import java.util.Collection;
import org.directwebremoting.Browser;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;

public class ScriptSessions {
    public static void setAttribute(final String name, final Object value) {
        Browser.withAllSessions(new Runnable(){

            public void run() {
                Collection<ScriptSession> sessions = Browser.getTargetSessions();
                for (ScriptSession scriptSession : sessions) {
                    scriptSession.setAttribute(name, value);
                }
            }
        });
    }

    public static void removeAttribute(final String name) {
        Browser.withAllSessions(new Runnable(){

            public void run() {
                Collection<ScriptSession> sessions = Browser.getTargetSessions();
                for (ScriptSession scriptSession : sessions) {
                    scriptSession.removeAttribute(name);
                }
            }
        });
    }

    public static void addScript(final ScriptBuffer script) {
        Browser.withAllSessions(new Runnable(){

            public void run() {
                Collection<ScriptSession> sessions = Browser.getTargetSessions();
                for (ScriptSession scriptSession : sessions) {
                    scriptSession.addScript(script);
                }
            }
        });
    }

    public static void addScript(String scriptString) {
        final ScriptBuffer script = new ScriptBuffer(scriptString);
        Browser.withAllSessions(new Runnable(){

            public void run() {
                Collection<ScriptSession> sessions = Browser.getTargetSessions();
                for (ScriptSession scriptSession : sessions) {
                    scriptSession.addScript(script);
                }
            }
        });
    }

    public static void addFunctionCall(String funcName, Object ... params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript(funcName).appendScript("(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                script.appendScript(",");
            }
            script.appendData(params[i]);
        }
        script.appendScript(");");
        ScriptSessions.addScript(script);
    }
}

