package jp.co.mk.oj.web.common.cache;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import jp.co.mk.oj.web.common.constants.StringConstants;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * vpeBt@C̃LbVsNXB
 * @author n@^K
 *
 */
public class PropertiesCash {

	/** logger */
	private static final Log log = LogFactory.getLog(PropertiesCash.class);

	/** vpeBt@CP[ɃLbV}bv */
	private static Map<String, Map<String, Map<String, String>>> localePropMap;
	
	/** NX̃IuWFNg */
	private static PropertiesCash obj;

	/** IuWFNg */
	private static final byte[] MUTEX = new byte[0];

	/** vCx[gRXgN^ */
	private PropertiesCash() {
		localePropMap = new HashMap<String, Map<String, Map<String, String>>>();
	}
	
	/**
	 * CX^X擾܂B
	 * @return NXB̃CX^XB
	 */
	public static PropertiesCash getInstance() {
		if (obj == null) {
			synchronized (MUTEX) {
				if (obj == null) {
					obj = new PropertiesCash();
				}
			}
		}
		return obj;
	}

	/**
	 * ΏۃP[̑SvpeB擾܂B
	 * @param localeString P[񂩂琶B
	 * @return YP[̑SvpeB񂪐ݒ肳ꂽMapB
	 */
	private Map<String, Map<String, String>> getTargetLocaleMap(String localeString) {
		
		synchronized (localePropMap) {
			Map<String, Map<String, String>> targetMap = localePropMap.get(localeString);
			if (targetMap == null) {
				targetMap = new HashMap<String, Map<String,String>>();
				localePropMap.put(localeString, targetMap);
			}
			return targetMap;
		}
	}

	/**
	 * ΏۃP[̑SvpeB񂩂<BR>
	 * w肳ꂽvpeBt@C̃vpeB擾܂B
	 * @param propertiesName ΏۃvpeBt@CB
	 * @param locale ΏۃP[B
	 * @return Ώۂ̃vpeBB
	 */
	private Map<String, String> getTargetPropertiesMap(String propertiesName, Locale locale) {
		
		if (locale == null) {
			locale = Locale.JAPAN;
		}

		// Ώۂ̃vpeBt@Cw肳ĂȂnullԂB
		if (StringUtils.isEmpty(propertiesName)) {
			return null;
		}
		// ΏۃP[̑SvpeB擾B
		Map<String, Map<String, String>> targetLocalePropMap = getTargetLocaleMap(getKeyStringFromLocale(locale));
		synchronized (targetLocalePropMap) {
			// w肳ꂽvpeBt@CMap擾
			Map<String, String> targetPropMap = targetLocalePropMap.get(propertiesName);
			if (targetPropMap == null) {
				load(propertiesName, locale);
				targetPropMap = targetLocalePropMap.get(propertiesName);
			}
			return targetPropMap;
		}
	}

	/**
	 * ΏۃP[̑SvpeBMap擾邽߂key<BR>
	 * P[񂩂擾܂B
	 * @param locale P[
	 * @return P[񂩂琶ꂽ
	 */
	private String getKeyStringFromLocale(Locale locale) {
		
		if (locale == null) {
			return StringConstants.EMPTY;
		}
		StringBuilder sb = new StringBuilder();
		if (StringUtils.isNotEmpty(locale.getLanguage())) {
			sb.append(StringConstants.UNDER_SCORE);
			sb.append(locale.getLanguage());
			if (StringUtils.isNotEmpty(locale.getCountry())) {
				sb.append(StringConstants.UNDER_SCORE);
				sb.append(locale.getCountry());
			}
		}
		return sb.toString();
	}

	/**
	 * vpeB擾܂B
	 * @param propertiesName vpeBt@C
	 * @param key vpeBkey
	 * @return vpeBt@Cɒ`Ăl
	 */
	public String getPropertyValue(String propertiesName, String key) {
		return getPropertyValue(propertiesName, key, null);
	}

	/**
	 * P[wŃvpeBt@C̏擾܂B
	 * @param propertiesName vpeBt@C
	 * @param key vpeBkey
	 * @param locale P[
	 * @return vpeBt@Cɒ`Ăl
	 */
	public String getPropertyValue(String propertiesName, String key, Locale locale) {
		
		// vpeBt@CEkey̎w肪ȂnullԂ
		if (StringUtils.isEmpty(propertiesName) || StringUtils.isEmpty(key)) {
			return null;
		}
		// Ώۂ̃vpeBt@C̏擾B
		Map<String, String> map = getTargetPropertiesMap(propertiesName, locale);
		if (map != null) {
			return map.get(key);
		}
		return null;
	}

	/**
	 * vpeBt@Cǂݍ݂܂B
	 * @param propertiesName vpeBt@C
	 * @param locale P[
	 */
	public void load(String propertiesName, Locale locale) {
		
		if (locale == null) {
			locale = Locale.JAPAN;
		}
		
		if (log.isDebugEnabled()) log.debug("load start -- properties = " + propertiesName + ", Locale = " + getKeyStringFromLocale(locale));
		System.out.println("load start -- properties = " + propertiesName + ", Locale = " + getKeyStringFromLocale(locale));
		// vpeBt@Cw肳ĂȂΏ͍sȂ
		if (StringUtils.isEmpty(propertiesName)) {
			return;
		}
		// Ώۂ̃P[Map擾
		Map<String, Map<String, String>> localeMap = getTargetLocaleMap(getKeyStringFromLocale(locale));
		// Ώۂ̃vpeBt@Ci[ĂMap擾
		Map<String, String> map = localeMap.get(propertiesName);
		if (map == null) {
			map = new HashMap<String, String>();
			localeMap.put(propertiesName, map);
		}
		System.out.println("Locale = " + getKeyStringFromLocale(locale));
		ResourceBundle rb = ResourceBundle.getBundle(propertiesName, locale);
		Enumeration<String> en = rb.getKeys();
		while (en.hasMoreElements()) {
			String key = en.nextElement();
			map.put(key, rb.getString(key));
			if (log.isDebugEnabled()) log.debug("mapping -- [" + key + "]:" + map.get(key));
			System.out.println("mapping -- [" + key + "]:" + map.get(key));
		}
	}

	/**
	 * w肳ꂽÕvpeBt@C̃f[^[h܂B
	 * @param propertiesName
	 * @param locale P[
	 */
	public void reload(String propertiesName, Locale locale) {
		getTargetLocaleMap(getKeyStringFromLocale(locale)).remove(propertiesName);
		load(propertiesName, locale);
	}
	
	/**
	 * w肳ꂽL[
	 * w肳ꂽÕvpeBt@C̃f[^LbV܂B
	 * @param key vpeBLbVkey
	 * @param propertiesName vpeBt@C
	 * @param locale P[
	 */
	public void load(String key, String propertiesName, Locale locale) {
		if (locale == null) {
			locale = Locale.JAPAN;
		}
		if (log.isDebugEnabled()) log.debug("load start -- key = " + key + ", properties = " + propertiesName + ", locale = " + getKeyStringFromLocale(locale));
		if (StringUtils.isEmpty(key) || StringUtils.isEmpty(propertiesName)) {
			return;
		}
		Map<String, String> map = new HashMap<String, String>();
		getTargetLocaleMap(getKeyStringFromLocale(locale)).put(key, map);
		
		ResourceBundle rb = ResourceBundle.getBundle(propertiesName, locale);
		Enumeration<String> en = rb.getKeys();
		while (en.hasMoreElements()) {
			String keyVal = en.nextElement();
			map.put(keyVal, rb.getString(keyVal));
			if (log.isDebugEnabled()) log.debug("mapping -- [" + keyVal + "]:" + map.get(keyVal));
		}
	}
}
