package jp.co.sample.tag;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

import jp.co.sample.contants.StringConstants;
import jp.co.sample.util.StringUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;





/**
 * リクエストパラメータの値を全てhidden値として出力する。
 * @author 生地　真規
 */
public class ParamHiddenTag extends BodyTagSupport {

	/** serial version.  */
	private static final long serialVersionUID = -395825560386373803L;
	
	/** logger */
	private static final Log log = LogFactory.getLog(ParamHiddenTag.class);
	
	/** 除外対象リクエスト名（「,」区切りで記述） */
	private String exclusion;

	@Override
	public int doStartTag() throws JspException {
		
		JspWriter out = pageContext.getOut();

		ServletRequest request = pageContext.getRequest();
		
		if (request.getAttribute("MULT_PART_KEY") != null) {
			request = (ServletRequest) request.getAttribute("MULT_PART_KEY");
		}

		// 除外対象
		Set<String> exclusionSet = new HashSet<String>();
		if (StringUtils.isNotEmpty(exclusion)) {
			if (log.isDebugEnabled()) log.debug("除外対象リクエスト----");
			String[] exclusionArray = exclusion.split(StringConstants.COMMA);
			if (exclusionArray != null && exclusionArray.length > 0) {
				for (String val : exclusionArray) {
					exclusionSet.add(val);
					if (log.isDebugEnabled()) log.debug(val);
				}
			}
			if (log.isDebugEnabled()) log.debug("----------------------");
		}
		
		try {
			@SuppressWarnings("unchecked")
			Map<String, String[]> map = request.getParameterMap();
			Iterator<String> ite = map.keySet().iterator();
			while (ite.hasNext()) {
				String key = ite.next();
				if (!exclusionSet.contains(key)) {
					// 除外対象でなければ出力
					String[] values = map.get(key);
					if (values != null) {
						if (log.isDebugEnabled()) log.debug("出力リクエスト----");
						for (String value : values) {
							if (log.isDebugEnabled()) log.debug(key + "=" + value);
							out.write("<input type=\"hidden\" name=\"" + key + "\" value=\"" + StringUtil.sanitize(value) + "\">\n");
						}
						if (log.isDebugEnabled()) log.debug("----------------------");
					}
				}
			}
		} catch (IOException e) {
			throw new JspException(e);
		}
		
		return SKIP_BODY;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.BodyTagSupport#release()
	 */
	@Override
	public void release() {

		super.release();
		exclusion = null;
	}

	/**
	 * exclusionに値を設定します。
	 * @param exclusion the exclusion to set
	 */
	public void setExclusion(String exclusion) {
		this.exclusion = exclusion;
	}

	
}
