package jp.co.sample.form;

import jp.co.sample.bean.LoginInfo;

import org.apache.struts.validator.ValidatorForm;

/**
 * アクションフォームの基底クラス。
 *
 * @author 生地 真規
 */
public abstract class BaseForm extends ValidatorForm {

	/** シリアルバージョンUID */
	private static final long serialVersionUID = 2655897579202133105L;
	
	/** ログイン情報 */
	private LoginInfo loginInfo;

	/**
	 * ログイン情報を取得します。
	 * @return ログイン情報
	 */
	protected LoginInfo getLoginInfo() {
		return loginInfo;
	}

	/**
	 * ログイン情報を設定します。
	 * @param ログイン情報
	 */
	public void setLoginInfo(LoginInfo loginInfo) {
		this.loginInfo = loginInfo;
	}

}
