package jp.co.sample.exception;

/**
 * システムエラーを示す例外。
 * @author 生地　真規
 *
 */
public class SystemErrorException extends RuntimeException {

	/** シリアルバージョンUID */
	private static final long serialVersionUID = -2983599330958315008L;

	/**
	 * コンストラクタ。
	 */
	public SystemErrorException() {
		super();
	}

	/**
	 * コンストラクタ。
	 * @param message メッセージ
	 */
	public SystemErrorException(String message) {
		super(message);
	}
	
	/**
	 * コンストラクタ。
	 * @param e 例外
	 */
	public SystemErrorException(Throwable e) {
		super(e);
	}
	
	/**
	 * コンストラクタ。
	 * @param message メッセージ
	 * @param e 例外
	 */
	public SystemErrorException(String message, Throwable e) {
		super(message, e);
	}
}
