package jp.co.sample.exception;

/**
 * アプリケーションエラーを示す例外。
 * エラーメッセージを取得するためのメッセージキーをインスタンス生成時に指定する。
 * メッセージキーはプロパティファイルに定義済みのものを指定する。
 * @author 生地　真規
 *
 */
public class ApplicationException extends RuntimeException {

	/** シリアルバージョンUID */
	private static final long serialVersionUID = 8458962616639353361L;
	
	/** メッセージキー */
	private String messageKey;
	
	/** メッセージ引数 */
	private String[] messageArgs;

	/** プライベートコンストラクタ */
	@SuppressWarnings("unused")
	private ApplicationException(){}

	/**
	 * コンストラクタ。
	 * @param messageKey メッセージキー
	 */
	public ApplicationException(String messageKey) {
		super();
		this.messageKey = messageKey;
	}

	/**
	 * コンストラクタ。
	 * @param messageKey メッセージキー
	 * @param messageArgs メッセージ引数
	 */
	public ApplicationException(String messageKey, String... messageArgs) {
		super();
		this.messageKey = messageKey;
		this.messageArgs = messageArgs;
	}

	/**
	 * コンストラクタ。
	 * @param e 例外
	 * @param messageKey メッセージキー
	 * @param messageArgs メッセージ引数
	 */
	public ApplicationException(Throwable e, String messageKey, String... messageArgs) {
		super(e);
		this.messageKey = messageKey;
		this.messageArgs = messageArgs;
	}

	/**
	 * コンストラクタ。
	 * @param message メッセージ
	 * @param e 例外
	 * @param messageKey メッセージキー
	 * @param messageArgs メッセージ引数
	 */
	public ApplicationException(String message, Throwable e, String messageKey, String... messageArgs) {
		super(message, e);
		this.messageKey = messageKey;
		this.messageArgs = messageArgs;
	}

	/**
	 * messageKeyを取得します。
	 * @return messageKey を取得します。
	 */
	public String getMessageKey() {
		return messageKey;
	}

	/**
	 * messageArgsを取得します。
	 * @return messageArgs を取得します。
	 */
	public String[] getMessageArgs() {
		return messageArgs;
	}
}
