package jp.co.sample.contants;

/**
 * よく使用される文字の定数クラス。
 * @author 生地　真規
 */
public class StringConstants {

	/** 空文字 */
	public static final String EMPTY = "";
	/** 半角スペース */
	public static final String SPACE = " ";
	/** 半角スペース(HTML) */
	public static final String SPACE_HTML = "&nbsp;";
	/** ドット */
	public static final String DOT = ".";
	/** カンマ */
	public static final String COMMA = ",";
	/** スラッシュ */
	public static final String SLASH = "/";
	/** コロン */
	public static final String COLON = ":";
	/** ハイフン */
	public static final String HYPHEN = "-";
	/** アンダースコア */
	public static final String UNDER_SCORE = "_";
	/** ゼロ */
	public static final String ZERO = "0";
	/** ゼロ */
	public static final char CHAR_ZERO = '0';
	/** CR LF */
	public static final String CR_LF = "\r\n";
	/** CR */
	public static final String CR = "\r";
	/** LF */
	public static final String LF = "\n";
	/** TAB */
	public static final String TAB = "\t";
	/** % */
	public static final String PERCENT = "%";
	/** 01 */
	public static final String ZERO_ONE = "01";
	/** &nbsp; */
	public static final String NBSP = "&nbsp;";
	/** TRUE */
	public static final String TRUE = Boolean.TRUE.toString();
	/** FALSE */
	public static final String FALSE = Boolean.FALSE.toString();
	/** 「=」 */
	public static final String EQUAL = "=";
	/** 「'」 */
	public static final String QUOT = "\'";
	/** 「"」 */
	public static final String DOUBLE_QUOT = "\"";

	/** ドットの正規表現 */
	public static final String REGEX_DOT = "\\.";

}
